package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  DirectoryPath,
  ConfigValue,
  S3Uri,
  OptionalVolumeSizeInGB,
  AlgorithmImage,
  RuleConfigurationName,
  ConfigKey
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DebugRuleConfiguration(
    ruleConfigurationName: RuleConfigurationName,
    localPath: Optional[DirectoryPath] = Optional.Absent,
    s3OutputPath: Optional[S3Uri] = Optional.Absent,
    ruleEvaluatorImage: AlgorithmImage,
    instanceType: Optional[zio.aws.sagemaker.model.ProcessingInstanceType] =
      Optional.Absent,
    volumeSizeInGB: Optional[OptionalVolumeSizeInGB] = Optional.Absent,
    ruleParameters: Optional[Map[ConfigKey, ConfigValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DebugRuleConfiguration = {
    import DebugRuleConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DebugRuleConfiguration
      .builder()
      .ruleConfigurationName(
        RuleConfigurationName.unwrap(ruleConfigurationName): java.lang.String
      )
      .optionallyWith(
        localPath.map(value => DirectoryPath.unwrap(value): java.lang.String)
      )(_.localPath)
      .optionallyWith(
        s3OutputPath.map(value => S3Uri.unwrap(value): java.lang.String)
      )(_.s3OutputPath)
      .ruleEvaluatorImage(
        AlgorithmImage.unwrap(ruleEvaluatorImage): java.lang.String
      )
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(
        volumeSizeInGB.map(value =>
          OptionalVolumeSizeInGB.unwrap(value): Integer
        )
      )(_.volumeSizeInGB)
      .optionallyWith(
        ruleParameters.map(value =>
          value
            .map({ case (key, value) =>
              (ConfigKey.unwrap(key): java.lang.String) -> (ConfigValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.ruleParameters)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DebugRuleConfiguration.ReadOnly =
    zio.aws.sagemaker.model.DebugRuleConfiguration.wrap(buildAwsValue())
}
object DebugRuleConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DebugRuleConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DebugRuleConfiguration =
      zio.aws.sagemaker.model.DebugRuleConfiguration(
        ruleConfigurationName,
        localPath.map(value => value),
        s3OutputPath.map(value => value),
        ruleEvaluatorImage,
        instanceType.map(value => value),
        volumeSizeInGB.map(value => value),
        ruleParameters.map(value => value)
      )
    def ruleConfigurationName: RuleConfigurationName
    def localPath: Optional[DirectoryPath]
    def s3OutputPath: Optional[S3Uri]
    def ruleEvaluatorImage: AlgorithmImage
    def instanceType: Optional[zio.aws.sagemaker.model.ProcessingInstanceType]
    def volumeSizeInGB: Optional[OptionalVolumeSizeInGB]
    def ruleParameters: Optional[Map[ConfigKey, ConfigValue]]
    def getRuleConfigurationName: ZIO[Any, Nothing, RuleConfigurationName] =
      ZIO.succeed(ruleConfigurationName)
    def getLocalPath: ZIO[Any, AwsError, DirectoryPath] =
      AwsError.unwrapOptionField("localPath", localPath)
    def getS3OutputPath: ZIO[Any, AwsError, S3Uri] =
      AwsError.unwrapOptionField("s3OutputPath", s3OutputPath)
    def getRuleEvaluatorImage: ZIO[Any, Nothing, AlgorithmImage] =
      ZIO.succeed(ruleEvaluatorImage)
    def getInstanceType
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ProcessingInstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getVolumeSizeInGB: ZIO[Any, AwsError, OptionalVolumeSizeInGB] =
      AwsError.unwrapOptionField("volumeSizeInGB", volumeSizeInGB)
    def getRuleParameters: ZIO[Any, AwsError, Map[ConfigKey, ConfigValue]] =
      AwsError.unwrapOptionField("ruleParameters", ruleParameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DebugRuleConfiguration
  ) extends zio.aws.sagemaker.model.DebugRuleConfiguration.ReadOnly {
    override val ruleConfigurationName: RuleConfigurationName =
      zio.aws.sagemaker.model.primitives
        .RuleConfigurationName(impl.ruleConfigurationName())
    override val localPath: Optional[DirectoryPath] = zio.aws.core.internal
      .optionalFromNullable(impl.localPath())
      .map(value => zio.aws.sagemaker.model.primitives.DirectoryPath(value))
    override val s3OutputPath: Optional[S3Uri] = zio.aws.core.internal
      .optionalFromNullable(impl.s3OutputPath())
      .map(value => zio.aws.sagemaker.model.primitives.S3Uri(value))
    override val ruleEvaluatorImage: AlgorithmImage =
      zio.aws.sagemaker.model.primitives
        .AlgorithmImage(impl.ruleEvaluatorImage())
    override val instanceType
        : Optional[zio.aws.sagemaker.model.ProcessingInstanceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceType())
        .map(value =>
          zio.aws.sagemaker.model.ProcessingInstanceType.wrap(value)
        )
    override val volumeSizeInGB: Optional[OptionalVolumeSizeInGB] =
      zio.aws.core.internal
        .optionalFromNullable(impl.volumeSizeInGB())
        .map(value =>
          zio.aws.sagemaker.model.primitives.OptionalVolumeSizeInGB(value)
        )
    override val ruleParameters: Optional[Map[ConfigKey, ConfigValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ruleParameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.sagemaker.model.primitives.ConfigKey(
                key
              ) -> zio.aws.sagemaker.model.primitives.ConfigValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DebugRuleConfiguration
  ): zio.aws.sagemaker.model.DebugRuleConfiguration.ReadOnly = new Wrapper(impl)
}
