package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{
  MLFramework,
  ReleaseNotes,
  ImageBaseImage,
  ClientToken,
  ImageName,
  Horovod,
  SageMakerImageVersionAlias,
  ProgrammingLang
}
import scala.jdk.CollectionConverters._
final case class CreateImageVersionRequest(
    baseImage: ImageBaseImage,
    clientToken: ClientToken,
    imageName: ImageName,
    aliases: Optional[Iterable[SageMakerImageVersionAlias]] = Optional.Absent,
    vendorGuidance: Optional[zio.aws.sagemaker.model.VendorGuidance] =
      Optional.Absent,
    jobType: Optional[zio.aws.sagemaker.model.JobType] = Optional.Absent,
    mlFramework: Optional[MLFramework] = Optional.Absent,
    programmingLang: Optional[ProgrammingLang] = Optional.Absent,
    processor: Optional[zio.aws.sagemaker.model.Processor] = Optional.Absent,
    horovod: Optional[Horovod] = Optional.Absent,
    releaseNotes: Optional[ReleaseNotes] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateImageVersionRequest = {
    import CreateImageVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateImageVersionRequest
      .builder()
      .baseImage(ImageBaseImage.unwrap(baseImage): java.lang.String)
      .clientToken(ClientToken.unwrap(clientToken): java.lang.String)
      .imageName(ImageName.unwrap(imageName): java.lang.String)
      .optionallyWith(
        aliases.map(value =>
          value.map { item =>
            SageMakerImageVersionAlias.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.aliases)
      .optionallyWith(vendorGuidance.map(value => value.unwrap))(
        _.vendorGuidance
      )
      .optionallyWith(jobType.map(value => value.unwrap))(_.jobType)
      .optionallyWith(
        mlFramework.map(value => MLFramework.unwrap(value): java.lang.String)
      )(_.mlFramework)
      .optionallyWith(
        programmingLang.map(value =>
          ProgrammingLang.unwrap(value): java.lang.String
        )
      )(_.programmingLang)
      .optionallyWith(processor.map(value => value.unwrap))(_.processor)
      .optionallyWith(
        horovod.map(value => Horovod.unwrap(value): java.lang.Boolean)
      )(_.horovod)
      .optionallyWith(
        releaseNotes.map(value => ReleaseNotes.unwrap(value): java.lang.String)
      )(_.releaseNotes)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateImageVersionRequest.ReadOnly =
    zio.aws.sagemaker.model.CreateImageVersionRequest.wrap(buildAwsValue())
}
object CreateImageVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateImageVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateImageVersionRequest =
      zio.aws.sagemaker.model.CreateImageVersionRequest(
        baseImage,
        clientToken,
        imageName,
        aliases.map(value => value),
        vendorGuidance.map(value => value),
        jobType.map(value => value),
        mlFramework.map(value => value),
        programmingLang.map(value => value),
        processor.map(value => value),
        horovod.map(value => value),
        releaseNotes.map(value => value)
      )
    def baseImage: ImageBaseImage
    def clientToken: ClientToken
    def imageName: ImageName
    def aliases: Optional[List[SageMakerImageVersionAlias]]
    def vendorGuidance: Optional[zio.aws.sagemaker.model.VendorGuidance]
    def jobType: Optional[zio.aws.sagemaker.model.JobType]
    def mlFramework: Optional[MLFramework]
    def programmingLang: Optional[ProgrammingLang]
    def processor: Optional[zio.aws.sagemaker.model.Processor]
    def horovod: Optional[Horovod]
    def releaseNotes: Optional[ReleaseNotes]
    def getBaseImage: ZIO[Any, Nothing, ImageBaseImage] = ZIO.succeed(baseImage)
    def getClientToken: ZIO[Any, Nothing, ClientToken] =
      ZIO.succeed(clientToken)
    def getImageName: ZIO[Any, Nothing, ImageName] = ZIO.succeed(imageName)
    def getAliases: ZIO[Any, AwsError, List[SageMakerImageVersionAlias]] =
      AwsError.unwrapOptionField("aliases", aliases)
    def getVendorGuidance
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.VendorGuidance] =
      AwsError.unwrapOptionField("vendorGuidance", vendorGuidance)
    def getJobType: ZIO[Any, AwsError, zio.aws.sagemaker.model.JobType] =
      AwsError.unwrapOptionField("jobType", jobType)
    def getMlFramework: ZIO[Any, AwsError, MLFramework] =
      AwsError.unwrapOptionField("mlFramework", mlFramework)
    def getProgrammingLang: ZIO[Any, AwsError, ProgrammingLang] =
      AwsError.unwrapOptionField("programmingLang", programmingLang)
    def getProcessor: ZIO[Any, AwsError, zio.aws.sagemaker.model.Processor] =
      AwsError.unwrapOptionField("processor", processor)
    def getHorovod: ZIO[Any, AwsError, Horovod] =
      AwsError.unwrapOptionField("horovod", horovod)
    def getReleaseNotes: ZIO[Any, AwsError, ReleaseNotes] =
      AwsError.unwrapOptionField("releaseNotes", releaseNotes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateImageVersionRequest
  ) extends zio.aws.sagemaker.model.CreateImageVersionRequest.ReadOnly {
    override val baseImage: ImageBaseImage =
      zio.aws.sagemaker.model.primitives.ImageBaseImage(impl.baseImage())
    override val clientToken: ClientToken =
      zio.aws.sagemaker.model.primitives.ClientToken(impl.clientToken())
    override val imageName: ImageName =
      zio.aws.sagemaker.model.primitives.ImageName(impl.imageName())
    override val aliases: Optional[List[SageMakerImageVersionAlias]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.aliases())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.primitives.SageMakerImageVersionAlias(item)
          }.toList
        )
    override val vendorGuidance
        : Optional[zio.aws.sagemaker.model.VendorGuidance] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vendorGuidance())
        .map(value => zio.aws.sagemaker.model.VendorGuidance.wrap(value))
    override val jobType: Optional[zio.aws.sagemaker.model.JobType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobType())
        .map(value => zio.aws.sagemaker.model.JobType.wrap(value))
    override val mlFramework: Optional[MLFramework] = zio.aws.core.internal
      .optionalFromNullable(impl.mlFramework())
      .map(value => zio.aws.sagemaker.model.primitives.MLFramework(value))
    override val programmingLang: Optional[ProgrammingLang] =
      zio.aws.core.internal
        .optionalFromNullable(impl.programmingLang())
        .map(value => zio.aws.sagemaker.model.primitives.ProgrammingLang(value))
    override val processor: Optional[zio.aws.sagemaker.model.Processor] =
      zio.aws.core.internal
        .optionalFromNullable(impl.processor())
        .map(value => zio.aws.sagemaker.model.Processor.wrap(value))
    override val horovod: Optional[Horovod] = zio.aws.core.internal
      .optionalFromNullable(impl.horovod())
      .map(value => zio.aws.sagemaker.model.primitives.Horovod(value))
    override val releaseNotes: Optional[ReleaseNotes] = zio.aws.core.internal
      .optionalFromNullable(impl.releaseNotes())
      .map(value => zio.aws.sagemaker.model.primitives.ReleaseNotes(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateImageVersionRequest
  ): zio.aws.sagemaker.model.CreateImageVersionRequest.ReadOnly = new Wrapper(
    impl
  )
}
