package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MonitoringCsvDatasetFormat(
    header: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.MonitoringCsvDatasetFormat = {
    import MonitoringCsvDatasetFormat.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.MonitoringCsvDatasetFormat
      .builder()
      .optionallyWith(header.map(value => value: java.lang.Boolean))(_.header)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.MonitoringCsvDatasetFormat.ReadOnly =
    zio.aws.sagemaker.model.MonitoringCsvDatasetFormat.wrap(buildAwsValue())
}
object MonitoringCsvDatasetFormat {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.MonitoringCsvDatasetFormat
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.MonitoringCsvDatasetFormat =
      zio.aws.sagemaker.model
        .MonitoringCsvDatasetFormat(header.map(value => value))
    def header: Optional[Boolean]
    def getHeader: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("header", header)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.MonitoringCsvDatasetFormat
  ) extends zio.aws.sagemaker.model.MonitoringCsvDatasetFormat.ReadOnly {
    override val header: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.header())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.MonitoringCsvDatasetFormat
  ): zio.aws.sagemaker.model.MonitoringCsvDatasetFormat.ReadOnly = new Wrapper(
    impl
  )
}
