package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MemberDefinition(
    cognitoMemberDefinition: Optional[
      zio.aws.sagemaker.model.CognitoMemberDefinition
    ] = Optional.Absent,
    oidcMemberDefinition: Optional[
      zio.aws.sagemaker.model.OidcMemberDefinition
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.MemberDefinition = {
    import MemberDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.MemberDefinition
      .builder()
      .optionallyWith(
        cognitoMemberDefinition.map(value => value.buildAwsValue())
      )(_.cognitoMemberDefinition)
      .optionallyWith(oidcMemberDefinition.map(value => value.buildAwsValue()))(
        _.oidcMemberDefinition
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.MemberDefinition.ReadOnly =
    zio.aws.sagemaker.model.MemberDefinition.wrap(buildAwsValue())
}
object MemberDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.MemberDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.MemberDefinition =
      zio.aws.sagemaker.model.MemberDefinition(
        cognitoMemberDefinition.map(value => value.asEditable),
        oidcMemberDefinition.map(value => value.asEditable)
      )
    def cognitoMemberDefinition
        : Optional[zio.aws.sagemaker.model.CognitoMemberDefinition.ReadOnly]
    def oidcMemberDefinition
        : Optional[zio.aws.sagemaker.model.OidcMemberDefinition.ReadOnly]
    def getCognitoMemberDefinition: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.CognitoMemberDefinition.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cognitoMemberDefinition",
      cognitoMemberDefinition
    )
    def getOidcMemberDefinition: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.OidcMemberDefinition.ReadOnly
    ] = AwsError.unwrapOptionField("oidcMemberDefinition", oidcMemberDefinition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.MemberDefinition
  ) extends zio.aws.sagemaker.model.MemberDefinition.ReadOnly {
    override val cognitoMemberDefinition
        : Optional[zio.aws.sagemaker.model.CognitoMemberDefinition.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cognitoMemberDefinition())
        .map(value =>
          zio.aws.sagemaker.model.CognitoMemberDefinition.wrap(value)
        )
    override val oidcMemberDefinition
        : Optional[zio.aws.sagemaker.model.OidcMemberDefinition.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.oidcMemberDefinition())
        .map(value => zio.aws.sagemaker.model.OidcMemberDefinition.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.MemberDefinition
  ): zio.aws.sagemaker.model.MemberDefinition.ReadOnly = new Wrapper(impl)
}
