package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  NextToken,
  NameContains,
  MaxResults,
  CreationTime
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListAlgorithmsRequest(
    creationTimeAfter: Optional[CreationTime] = Optional.Absent,
    creationTimeBefore: Optional[CreationTime] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nameContains: Optional[NameContains] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    sortBy: Optional[zio.aws.sagemaker.model.AlgorithmSortBy] = Optional.Absent,
    sortOrder: Optional[zio.aws.sagemaker.model.SortOrder] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListAlgorithmsRequest = {
    import ListAlgorithmsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListAlgorithmsRequest
      .builder()
      .optionallyWith(
        creationTimeAfter.map(value => CreationTime.unwrap(value): Instant)
      )(_.creationTimeAfter)
      .optionallyWith(
        creationTimeBefore.map(value => CreationTime.unwrap(value): Instant)
      )(_.creationTimeBefore)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nameContains.map(value => NameContains.unwrap(value): java.lang.String)
      )(_.nameContains)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListAlgorithmsRequest.ReadOnly =
    zio.aws.sagemaker.model.ListAlgorithmsRequest.wrap(buildAwsValue())
}
object ListAlgorithmsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListAlgorithmsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListAlgorithmsRequest =
      zio.aws.sagemaker.model.ListAlgorithmsRequest(
        creationTimeAfter.map(value => value),
        creationTimeBefore.map(value => value),
        maxResults.map(value => value),
        nameContains.map(value => value),
        nextToken.map(value => value),
        sortBy.map(value => value),
        sortOrder.map(value => value)
      )
    def creationTimeAfter: Optional[CreationTime]
    def creationTimeBefore: Optional[CreationTime]
    def maxResults: Optional[MaxResults]
    def nameContains: Optional[NameContains]
    def nextToken: Optional[NextToken]
    def sortBy: Optional[zio.aws.sagemaker.model.AlgorithmSortBy]
    def sortOrder: Optional[zio.aws.sagemaker.model.SortOrder]
    def getCreationTimeAfter: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("creationTimeAfter", creationTimeAfter)
    def getCreationTimeBefore: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("creationTimeBefore", creationTimeBefore)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNameContains: ZIO[Any, AwsError, NameContains] =
      AwsError.unwrapOptionField("nameContains", nameContains)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSortBy: ZIO[Any, AwsError, zio.aws.sagemaker.model.AlgorithmSortBy] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.sagemaker.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListAlgorithmsRequest
  ) extends zio.aws.sagemaker.model.ListAlgorithmsRequest.ReadOnly {
    override val creationTimeAfter: Optional[CreationTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationTimeAfter())
        .map(value => zio.aws.sagemaker.model.primitives.CreationTime(value))
    override val creationTimeBefore: Optional[CreationTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationTimeBefore())
        .map(value => zio.aws.sagemaker.model.primitives.CreationTime(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.MaxResults(value))
    override val nameContains: Optional[NameContains] = zio.aws.core.internal
      .optionalFromNullable(impl.nameContains())
      .map(value => zio.aws.sagemaker.model.primitives.NameContains(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val sortBy: Optional[zio.aws.sagemaker.model.AlgorithmSortBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value => zio.aws.sagemaker.model.AlgorithmSortBy.wrap(value))
    override val sortOrder: Optional[zio.aws.sagemaker.model.SortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.sagemaker.model.SortOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListAlgorithmsRequest
  ): zio.aws.sagemaker.model.ListAlgorithmsRequest.ReadOnly = new Wrapper(impl)
}
