package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait HubStatus {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.HubStatus
}
object HubStatus {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.HubStatus
  ): zio.aws.sagemaker.model.HubStatus = value match {
    case software.amazon.awssdk.services.sagemaker.model.HubStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.HubStatus.IN_SERVICE =>
      val r = InService
      r
    case software.amazon.awssdk.services.sagemaker.model.HubStatus.CREATING =>
      val r = Creating
      r
    case software.amazon.awssdk.services.sagemaker.model.HubStatus.UPDATING =>
      val r = Updating
      r
    case software.amazon.awssdk.services.sagemaker.model.HubStatus.DELETING =>
      val r = Deleting
      r
    case software.amazon.awssdk.services.sagemaker.model.HubStatus.CREATE_FAILED =>
      val r = CreateFailed
      r
    case software.amazon.awssdk.services.sagemaker.model.HubStatus.UPDATE_FAILED =>
      val r = UpdateFailed
      r
    case software.amazon.awssdk.services.sagemaker.model.HubStatus.DELETE_FAILED =>
      val r = DeleteFailed
      r
  }
  case object unknownToSdkVersion extends zio.aws.sagemaker.model.HubStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.HubStatus =
      software.amazon.awssdk.services.sagemaker.model.HubStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object InService extends zio.aws.sagemaker.model.HubStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.HubStatus =
      software.amazon.awssdk.services.sagemaker.model.HubStatus.IN_SERVICE
  }
  case object Creating extends zio.aws.sagemaker.model.HubStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.HubStatus =
      software.amazon.awssdk.services.sagemaker.model.HubStatus.CREATING
  }
  case object Updating extends zio.aws.sagemaker.model.HubStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.HubStatus =
      software.amazon.awssdk.services.sagemaker.model.HubStatus.UPDATING
  }
  case object Deleting extends zio.aws.sagemaker.model.HubStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.HubStatus =
      software.amazon.awssdk.services.sagemaker.model.HubStatus.DELETING
  }
  case object CreateFailed extends zio.aws.sagemaker.model.HubStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.HubStatus =
      software.amazon.awssdk.services.sagemaker.model.HubStatus.CREATE_FAILED
  }
  case object UpdateFailed extends zio.aws.sagemaker.model.HubStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.HubStatus =
      software.amazon.awssdk.services.sagemaker.model.HubStatus.UPDATE_FAILED
  }
  case object DeleteFailed extends zio.aws.sagemaker.model.HubStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.HubStatus =
      software.amazon.awssdk.services.sagemaker.model.HubStatus.DELETE_FAILED
  }
}
