package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  StudioLifecycleConfigContent,
  Timestamp,
  StudioLifecycleConfigName,
  StudioLifecycleConfigArn
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeStudioLifecycleConfigResponse(
    studioLifecycleConfigArn: Optional[StudioLifecycleConfigArn] =
      Optional.Absent,
    studioLifecycleConfigName: Optional[StudioLifecycleConfigName] =
      Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent,
    studioLifecycleConfigContent: Optional[StudioLifecycleConfigContent] =
      Optional.Absent,
    studioLifecycleConfigAppType: Optional[
      zio.aws.sagemaker.model.StudioLifecycleConfigAppType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeStudioLifecycleConfigResponse = {
    import DescribeStudioLifecycleConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeStudioLifecycleConfigResponse
      .builder()
      .optionallyWith(
        studioLifecycleConfigArn.map(value =>
          StudioLifecycleConfigArn.unwrap(value): java.lang.String
        )
      )(_.studioLifecycleConfigArn)
      .optionallyWith(
        studioLifecycleConfigName.map(value =>
          StudioLifecycleConfigName.unwrap(value): java.lang.String
        )
      )(_.studioLifecycleConfigName)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(
        studioLifecycleConfigContent.map(value =>
          StudioLifecycleConfigContent.unwrap(value): java.lang.String
        )
      )(_.studioLifecycleConfigContent)
      .optionallyWith(studioLifecycleConfigAppType.map(value => value.unwrap))(
        _.studioLifecycleConfigAppType
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribeStudioLifecycleConfigResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeStudioLifecycleConfigResponse
      .wrap(buildAwsValue())
}
object DescribeStudioLifecycleConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeStudioLifecycleConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.DescribeStudioLifecycleConfigResponse =
      zio.aws.sagemaker.model.DescribeStudioLifecycleConfigResponse(
        studioLifecycleConfigArn.map(value => value),
        studioLifecycleConfigName.map(value => value),
        creationTime.map(value => value),
        lastModifiedTime.map(value => value),
        studioLifecycleConfigContent.map(value => value),
        studioLifecycleConfigAppType.map(value => value)
      )
    def studioLifecycleConfigArn: Optional[StudioLifecycleConfigArn]
    def studioLifecycleConfigName: Optional[StudioLifecycleConfigName]
    def creationTime: Optional[Timestamp]
    def lastModifiedTime: Optional[Timestamp]
    def studioLifecycleConfigContent: Optional[StudioLifecycleConfigContent]
    def studioLifecycleConfigAppType
        : Optional[zio.aws.sagemaker.model.StudioLifecycleConfigAppType]
    def getStudioLifecycleConfigArn
        : ZIO[Any, AwsError, StudioLifecycleConfigArn] = AwsError
      .unwrapOptionField("studioLifecycleConfigArn", studioLifecycleConfigArn)
    def getStudioLifecycleConfigName
        : ZIO[Any, AwsError, StudioLifecycleConfigName] = AwsError
      .unwrapOptionField("studioLifecycleConfigName", studioLifecycleConfigName)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getStudioLifecycleConfigContent
        : ZIO[Any, AwsError, StudioLifecycleConfigContent] =
      AwsError.unwrapOptionField(
        "studioLifecycleConfigContent",
        studioLifecycleConfigContent
      )
    def getStudioLifecycleConfigAppType: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.StudioLifecycleConfigAppType
    ] = AwsError.unwrapOptionField(
      "studioLifecycleConfigAppType",
      studioLifecycleConfigAppType
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeStudioLifecycleConfigResponse
  ) extends zio.aws.sagemaker.model.DescribeStudioLifecycleConfigResponse.ReadOnly {
    override val studioLifecycleConfigArn: Optional[StudioLifecycleConfigArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.studioLifecycleConfigArn())
        .map(value =>
          zio.aws.sagemaker.model.primitives.StudioLifecycleConfigArn(value)
        )
    override val studioLifecycleConfigName
        : Optional[StudioLifecycleConfigName] = zio.aws.core.internal
      .optionalFromNullable(impl.studioLifecycleConfigName())
      .map(value =>
        zio.aws.sagemaker.model.primitives.StudioLifecycleConfigName(value)
      )
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val studioLifecycleConfigContent
        : Optional[StudioLifecycleConfigContent] = zio.aws.core.internal
      .optionalFromNullable(impl.studioLifecycleConfigContent())
      .map(value =>
        zio.aws.sagemaker.model.primitives.StudioLifecycleConfigContent(value)
      )
    override val studioLifecycleConfigAppType
        : Optional[zio.aws.sagemaker.model.StudioLifecycleConfigAppType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.studioLifecycleConfigAppType())
        .map(value =>
          zio.aws.sagemaker.model.StudioLifecycleConfigAppType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeStudioLifecycleConfigResponse
  ): zio.aws.sagemaker.model.DescribeStudioLifecycleConfigResponse.ReadOnly =
    new Wrapper(impl)
}
