package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  RoleArn,
  FlowDefinitionName,
  Timestamp,
  FailureReason,
  FlowDefinitionArn
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeFlowDefinitionResponse(
    flowDefinitionArn: FlowDefinitionArn,
    flowDefinitionName: FlowDefinitionName,
    flowDefinitionStatus: zio.aws.sagemaker.model.FlowDefinitionStatus,
    creationTime: Timestamp,
    humanLoopRequestSource: Optional[
      zio.aws.sagemaker.model.HumanLoopRequestSource
    ] = Optional.Absent,
    humanLoopActivationConfig: Optional[
      zio.aws.sagemaker.model.HumanLoopActivationConfig
    ] = Optional.Absent,
    humanLoopConfig: zio.aws.sagemaker.model.HumanLoopConfig,
    outputConfig: zio.aws.sagemaker.model.FlowDefinitionOutputConfig,
    roleArn: RoleArn,
    failureReason: Optional[FailureReason] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeFlowDefinitionResponse = {
    import DescribeFlowDefinitionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeFlowDefinitionResponse
      .builder()
      .flowDefinitionArn(
        FlowDefinitionArn.unwrap(flowDefinitionArn): java.lang.String
      )
      .flowDefinitionName(
        FlowDefinitionName.unwrap(flowDefinitionName): java.lang.String
      )
      .flowDefinitionStatus(flowDefinitionStatus.unwrap)
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .optionallyWith(
        humanLoopRequestSource.map(value => value.buildAwsValue())
      )(_.humanLoopRequestSource)
      .optionallyWith(
        humanLoopActivationConfig.map(value => value.buildAwsValue())
      )(_.humanLoopActivationConfig)
      .humanLoopConfig(humanLoopConfig.buildAwsValue())
      .outputConfig(outputConfig.buildAwsValue())
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribeFlowDefinitionResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeFlowDefinitionResponse.wrap(buildAwsValue())
}
object DescribeFlowDefinitionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeFlowDefinitionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeFlowDefinitionResponse =
      zio.aws.sagemaker.model.DescribeFlowDefinitionResponse(
        flowDefinitionArn,
        flowDefinitionName,
        flowDefinitionStatus,
        creationTime,
        humanLoopRequestSource.map(value => value.asEditable),
        humanLoopActivationConfig.map(value => value.asEditable),
        humanLoopConfig.asEditable,
        outputConfig.asEditable,
        roleArn,
        failureReason.map(value => value)
      )
    def flowDefinitionArn: FlowDefinitionArn
    def flowDefinitionName: FlowDefinitionName
    def flowDefinitionStatus: zio.aws.sagemaker.model.FlowDefinitionStatus
    def creationTime: Timestamp
    def humanLoopRequestSource
        : Optional[zio.aws.sagemaker.model.HumanLoopRequestSource.ReadOnly]
    def humanLoopActivationConfig
        : Optional[zio.aws.sagemaker.model.HumanLoopActivationConfig.ReadOnly]
    def humanLoopConfig: zio.aws.sagemaker.model.HumanLoopConfig.ReadOnly
    def outputConfig
        : zio.aws.sagemaker.model.FlowDefinitionOutputConfig.ReadOnly
    def roleArn: RoleArn
    def failureReason: Optional[FailureReason]
    def getFlowDefinitionArn: ZIO[Any, Nothing, FlowDefinitionArn] =
      ZIO.succeed(flowDefinitionArn)
    def getFlowDefinitionName: ZIO[Any, Nothing, FlowDefinitionName] =
      ZIO.succeed(flowDefinitionName)
    def getFlowDefinitionStatus
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.FlowDefinitionStatus] =
      ZIO.succeed(flowDefinitionStatus)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getHumanLoopRequestSource: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.HumanLoopRequestSource.ReadOnly
    ] = AwsError.unwrapOptionField(
      "humanLoopRequestSource",
      humanLoopRequestSource
    )
    def getHumanLoopActivationConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.HumanLoopActivationConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "humanLoopActivationConfig",
      humanLoopActivationConfig
    )
    def getHumanLoopConfig
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.HumanLoopConfig.ReadOnly] =
      ZIO.succeed(humanLoopConfig)
    def getOutputConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.FlowDefinitionOutputConfig.ReadOnly
    ] = ZIO.succeed(outputConfig)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeFlowDefinitionResponse
  ) extends zio.aws.sagemaker.model.DescribeFlowDefinitionResponse.ReadOnly {
    override val flowDefinitionArn: FlowDefinitionArn =
      zio.aws.sagemaker.model.primitives
        .FlowDefinitionArn(impl.flowDefinitionArn())
    override val flowDefinitionName: FlowDefinitionName =
      zio.aws.sagemaker.model.primitives
        .FlowDefinitionName(impl.flowDefinitionName())
    override val flowDefinitionStatus
        : zio.aws.sagemaker.model.FlowDefinitionStatus =
      zio.aws.sagemaker.model.FlowDefinitionStatus
        .wrap(impl.flowDefinitionStatus())
    override val creationTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.creationTime())
    override val humanLoopRequestSource
        : Optional[zio.aws.sagemaker.model.HumanLoopRequestSource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.humanLoopRequestSource())
        .map(value =>
          zio.aws.sagemaker.model.HumanLoopRequestSource.wrap(value)
        )
    override val humanLoopActivationConfig
        : Optional[zio.aws.sagemaker.model.HumanLoopActivationConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.humanLoopActivationConfig())
        .map(value =>
          zio.aws.sagemaker.model.HumanLoopActivationConfig.wrap(value)
        )
    override val humanLoopConfig
        : zio.aws.sagemaker.model.HumanLoopConfig.ReadOnly =
      zio.aws.sagemaker.model.HumanLoopConfig.wrap(impl.humanLoopConfig())
    override val outputConfig
        : zio.aws.sagemaker.model.FlowDefinitionOutputConfig.ReadOnly =
      zio.aws.sagemaker.model.FlowDefinitionOutputConfig
        .wrap(impl.outputConfig())
    override val roleArn: RoleArn =
      zio.aws.sagemaker.model.primitives.RoleArn(impl.roleArn())
    override val failureReason: Optional[FailureReason] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => zio.aws.sagemaker.model.primitives.FailureReason(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeFlowDefinitionResponse
  ): zio.aws.sagemaker.model.DescribeFlowDefinitionResponse.ReadOnly =
    new Wrapper(impl)
}
