package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{RoleArn, FlowDefinitionName}
import scala.jdk.CollectionConverters._
final case class CreateFlowDefinitionRequest(
    flowDefinitionName: FlowDefinitionName,
    humanLoopRequestSource: Optional[
      zio.aws.sagemaker.model.HumanLoopRequestSource
    ] = Optional.Absent,
    humanLoopActivationConfig: Optional[
      zio.aws.sagemaker.model.HumanLoopActivationConfig
    ] = Optional.Absent,
    humanLoopConfig: zio.aws.sagemaker.model.HumanLoopConfig,
    outputConfig: zio.aws.sagemaker.model.FlowDefinitionOutputConfig,
    roleArn: RoleArn,
    tags: Optional[Iterable[zio.aws.sagemaker.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateFlowDefinitionRequest = {
    import CreateFlowDefinitionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateFlowDefinitionRequest
      .builder()
      .flowDefinitionName(
        FlowDefinitionName.unwrap(flowDefinitionName): java.lang.String
      )
      .optionallyWith(
        humanLoopRequestSource.map(value => value.buildAwsValue())
      )(_.humanLoopRequestSource)
      .optionallyWith(
        humanLoopActivationConfig.map(value => value.buildAwsValue())
      )(_.humanLoopActivationConfig)
      .humanLoopConfig(humanLoopConfig.buildAwsValue())
      .outputConfig(outputConfig.buildAwsValue())
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateFlowDefinitionRequest.ReadOnly =
    zio.aws.sagemaker.model.CreateFlowDefinitionRequest.wrap(buildAwsValue())
}
object CreateFlowDefinitionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateFlowDefinitionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateFlowDefinitionRequest =
      zio.aws.sagemaker.model.CreateFlowDefinitionRequest(
        flowDefinitionName,
        humanLoopRequestSource.map(value => value.asEditable),
        humanLoopActivationConfig.map(value => value.asEditable),
        humanLoopConfig.asEditable,
        outputConfig.asEditable,
        roleArn,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def flowDefinitionName: FlowDefinitionName
    def humanLoopRequestSource
        : Optional[zio.aws.sagemaker.model.HumanLoopRequestSource.ReadOnly]
    def humanLoopActivationConfig
        : Optional[zio.aws.sagemaker.model.HumanLoopActivationConfig.ReadOnly]
    def humanLoopConfig: zio.aws.sagemaker.model.HumanLoopConfig.ReadOnly
    def outputConfig
        : zio.aws.sagemaker.model.FlowDefinitionOutputConfig.ReadOnly
    def roleArn: RoleArn
    def tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def getFlowDefinitionName: ZIO[Any, Nothing, FlowDefinitionName] =
      ZIO.succeed(flowDefinitionName)
    def getHumanLoopRequestSource: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.HumanLoopRequestSource.ReadOnly
    ] = AwsError.unwrapOptionField(
      "humanLoopRequestSource",
      humanLoopRequestSource
    )
    def getHumanLoopActivationConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.HumanLoopActivationConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "humanLoopActivationConfig",
      humanLoopActivationConfig
    )
    def getHumanLoopConfig
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.HumanLoopConfig.ReadOnly] =
      ZIO.succeed(humanLoopConfig)
    def getOutputConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.FlowDefinitionOutputConfig.ReadOnly
    ] = ZIO.succeed(outputConfig)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateFlowDefinitionRequest
  ) extends zio.aws.sagemaker.model.CreateFlowDefinitionRequest.ReadOnly {
    override val flowDefinitionName: FlowDefinitionName =
      zio.aws.sagemaker.model.primitives
        .FlowDefinitionName(impl.flowDefinitionName())
    override val humanLoopRequestSource
        : Optional[zio.aws.sagemaker.model.HumanLoopRequestSource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.humanLoopRequestSource())
        .map(value =>
          zio.aws.sagemaker.model.HumanLoopRequestSource.wrap(value)
        )
    override val humanLoopActivationConfig
        : Optional[zio.aws.sagemaker.model.HumanLoopActivationConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.humanLoopActivationConfig())
        .map(value =>
          zio.aws.sagemaker.model.HumanLoopActivationConfig.wrap(value)
        )
    override val humanLoopConfig
        : zio.aws.sagemaker.model.HumanLoopConfig.ReadOnly =
      zio.aws.sagemaker.model.HumanLoopConfig.wrap(impl.humanLoopConfig())
    override val outputConfig
        : zio.aws.sagemaker.model.FlowDefinitionOutputConfig.ReadOnly =
      zio.aws.sagemaker.model.FlowDefinitionOutputConfig
        .wrap(impl.outputConfig())
    override val roleArn: RoleArn =
      zio.aws.sagemaker.model.primitives.RoleArn(impl.roleArn())
    override val tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateFlowDefinitionRequest
  ): zio.aws.sagemaker.model.CreateFlowDefinitionRequest.ReadOnly = new Wrapper(
    impl
  )
}
