package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.AppImageConfigArn
import scala.jdk.CollectionConverters._
final case class CreateAppImageConfigResponse(
    appImageConfigArn: Optional[AppImageConfigArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateAppImageConfigResponse = {
    import CreateAppImageConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateAppImageConfigResponse
      .builder()
      .optionallyWith(
        appImageConfigArn.map(value =>
          AppImageConfigArn.unwrap(value): java.lang.String
        )
      )(_.appImageConfigArn)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.CreateAppImageConfigResponse.ReadOnly =
    zio.aws.sagemaker.model.CreateAppImageConfigResponse.wrap(buildAwsValue())
}
object CreateAppImageConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateAppImageConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateAppImageConfigResponse =
      zio.aws.sagemaker.model
        .CreateAppImageConfigResponse(appImageConfigArn.map(value => value))
    def appImageConfigArn: Optional[AppImageConfigArn]
    def getAppImageConfigArn: ZIO[Any, AwsError, AppImageConfigArn] =
      AwsError.unwrapOptionField("appImageConfigArn", appImageConfigArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateAppImageConfigResponse
  ) extends zio.aws.sagemaker.model.CreateAppImageConfigResponse.ReadOnly {
    override val appImageConfigArn: Optional[AppImageConfigArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.appImageConfigArn())
        .map(value =>
          zio.aws.sagemaker.model.primitives.AppImageConfigArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateAppImageConfigResponse
  ): zio.aws.sagemaker.model.CreateAppImageConfigResponse.ReadOnly =
    new Wrapper(impl)
}
