package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  ExperimentEntityName,
  TrialComponentKey64,
  TrialComponentArn,
  Timestamp,
  LineageGroupArn,
  TrialComponentKey256
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class TrialComponent(
    trialComponentName: Optional[ExperimentEntityName] = Optional.Absent,
    displayName: Optional[ExperimentEntityName] = Optional.Absent,
    trialComponentArn: Optional[TrialComponentArn] = Optional.Absent,
    source: Optional[zio.aws.sagemaker.model.TrialComponentSource] =
      Optional.Absent,
    status: Optional[zio.aws.sagemaker.model.TrialComponentStatus] =
      Optional.Absent,
    startTime: Optional[Timestamp] = Optional.Absent,
    endTime: Optional[Timestamp] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    createdBy: Optional[zio.aws.sagemaker.model.UserContext] = Optional.Absent,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent,
    lastModifiedBy: Optional[zio.aws.sagemaker.model.UserContext] =
      Optional.Absent,
    parameters: Optional[Map[
      TrialComponentKey256,
      zio.aws.sagemaker.model.TrialComponentParameterValue
    ]] = Optional.Absent,
    inputArtifacts: Optional[
      Map[TrialComponentKey64, zio.aws.sagemaker.model.TrialComponentArtifact]
    ] = Optional.Absent,
    outputArtifacts: Optional[
      Map[TrialComponentKey64, zio.aws.sagemaker.model.TrialComponentArtifact]
    ] = Optional.Absent,
    metrics: Optional[
      Iterable[zio.aws.sagemaker.model.TrialComponentMetricSummary]
    ] = Optional.Absent,
    metadataProperties: Optional[zio.aws.sagemaker.model.MetadataProperties] =
      Optional.Absent,
    sourceDetail: Optional[zio.aws.sagemaker.model.TrialComponentSourceDetail] =
      Optional.Absent,
    lineageGroupArn: Optional[LineageGroupArn] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.sagemaker.model.Tag]] = Optional.Absent,
    parents: Optional[Iterable[zio.aws.sagemaker.model.Parent]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.TrialComponent = {
    import TrialComponent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.TrialComponent
      .builder()
      .optionallyWith(
        trialComponentName.map(value =>
          ExperimentEntityName.unwrap(value): java.lang.String
        )
      )(_.trialComponentName)
      .optionallyWith(
        displayName.map(value =>
          ExperimentEntityName.unwrap(value): java.lang.String
        )
      )(_.displayName)
      .optionallyWith(
        trialComponentArn.map(value =>
          TrialComponentArn.unwrap(value): java.lang.String
        )
      )(_.trialComponentArn)
      .optionallyWith(source.map(value => value.buildAwsValue()))(_.source)
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(createdBy.map(value => value.buildAwsValue()))(
        _.createdBy
      )
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(lastModifiedBy.map(value => value.buildAwsValue()))(
        _.lastModifiedBy
      )
      .optionallyWith(
        parameters.map(value =>
          value
            .map({ case (key, value) =>
              (TrialComponentKey256.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.parameters)
      .optionallyWith(
        inputArtifacts.map(value =>
          value
            .map({ case (key, value) =>
              (TrialComponentKey64.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.inputArtifacts)
      .optionallyWith(
        outputArtifacts.map(value =>
          value
            .map({ case (key, value) =>
              (TrialComponentKey64.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.outputArtifacts)
      .optionallyWith(
        metrics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metrics)
      .optionallyWith(metadataProperties.map(value => value.buildAwsValue()))(
        _.metadataProperties
      )
      .optionallyWith(sourceDetail.map(value => value.buildAwsValue()))(
        _.sourceDetail
      )
      .optionallyWith(
        lineageGroupArn.map(value =>
          LineageGroupArn.unwrap(value): java.lang.String
        )
      )(_.lineageGroupArn)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        parents.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parents)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.TrialComponent.ReadOnly =
    zio.aws.sagemaker.model.TrialComponent.wrap(buildAwsValue())
}
object TrialComponent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.TrialComponent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.TrialComponent =
      zio.aws.sagemaker.model.TrialComponent(
        trialComponentName.map(value => value),
        displayName.map(value => value),
        trialComponentArn.map(value => value),
        source.map(value => value.asEditable),
        status.map(value => value.asEditable),
        startTime.map(value => value),
        endTime.map(value => value),
        creationTime.map(value => value),
        createdBy.map(value => value.asEditable),
        lastModifiedTime.map(value => value),
        lastModifiedBy.map(value => value.asEditable),
        parameters.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        inputArtifacts.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        outputArtifacts.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        metrics.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        metadataProperties.map(value => value.asEditable),
        sourceDetail.map(value => value.asEditable),
        lineageGroupArn.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        parents.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def trialComponentName: Optional[ExperimentEntityName]
    def displayName: Optional[ExperimentEntityName]
    def trialComponentArn: Optional[TrialComponentArn]
    def source: Optional[zio.aws.sagemaker.model.TrialComponentSource.ReadOnly]
    def status: Optional[zio.aws.sagemaker.model.TrialComponentStatus.ReadOnly]
    def startTime: Optional[Timestamp]
    def endTime: Optional[Timestamp]
    def creationTime: Optional[Timestamp]
    def createdBy: Optional[zio.aws.sagemaker.model.UserContext.ReadOnly]
    def lastModifiedTime: Optional[Timestamp]
    def lastModifiedBy: Optional[zio.aws.sagemaker.model.UserContext.ReadOnly]
    def parameters: Optional[Map[
      TrialComponentKey256,
      zio.aws.sagemaker.model.TrialComponentParameterValue.ReadOnly
    ]]
    def inputArtifacts: Optional[Map[
      TrialComponentKey64,
      zio.aws.sagemaker.model.TrialComponentArtifact.ReadOnly
    ]]
    def outputArtifacts: Optional[Map[
      TrialComponentKey64,
      zio.aws.sagemaker.model.TrialComponentArtifact.ReadOnly
    ]]
    def metrics: Optional[
      List[zio.aws.sagemaker.model.TrialComponentMetricSummary.ReadOnly]
    ]
    def metadataProperties
        : Optional[zio.aws.sagemaker.model.MetadataProperties.ReadOnly]
    def sourceDetail
        : Optional[zio.aws.sagemaker.model.TrialComponentSourceDetail.ReadOnly]
    def lineageGroupArn: Optional[LineageGroupArn]
    def tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def parents: Optional[List[zio.aws.sagemaker.model.Parent.ReadOnly]]
    def getTrialComponentName: ZIO[Any, AwsError, ExperimentEntityName] =
      AwsError.unwrapOptionField("trialComponentName", trialComponentName)
    def getDisplayName: ZIO[Any, AwsError, ExperimentEntityName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getTrialComponentArn: ZIO[Any, AwsError, TrialComponentArn] =
      AwsError.unwrapOptionField("trialComponentArn", trialComponentArn)
    def getSource: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.TrialComponentSource.ReadOnly
    ] = AwsError.unwrapOptionField("source", source)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.TrialComponentStatus.ReadOnly
    ] = AwsError.unwrapOptionField("status", status)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getCreatedBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UserContext.ReadOnly] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getLastModifiedBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UserContext.ReadOnly] =
      AwsError.unwrapOptionField("lastModifiedBy", lastModifiedBy)
    def getParameters: ZIO[Any, AwsError, Map[
      TrialComponentKey256,
      zio.aws.sagemaker.model.TrialComponentParameterValue.ReadOnly
    ]] = AwsError.unwrapOptionField("parameters", parameters)
    def getInputArtifacts: ZIO[Any, AwsError, Map[
      TrialComponentKey64,
      zio.aws.sagemaker.model.TrialComponentArtifact.ReadOnly
    ]] = AwsError.unwrapOptionField("inputArtifacts", inputArtifacts)
    def getOutputArtifacts: ZIO[Any, AwsError, Map[
      TrialComponentKey64,
      zio.aws.sagemaker.model.TrialComponentArtifact.ReadOnly
    ]] = AwsError.unwrapOptionField("outputArtifacts", outputArtifacts)
    def getMetrics: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.TrialComponentMetricSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("metrics", metrics)
    def getMetadataProperties: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.MetadataProperties.ReadOnly
    ] = AwsError.unwrapOptionField("metadataProperties", metadataProperties)
    def getSourceDetail: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.TrialComponentSourceDetail.ReadOnly
    ] = AwsError.unwrapOptionField("sourceDetail", sourceDetail)
    def getLineageGroupArn: ZIO[Any, AwsError, LineageGroupArn] =
      AwsError.unwrapOptionField("lineageGroupArn", lineageGroupArn)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getParents
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Parent.ReadOnly]] =
      AwsError.unwrapOptionField("parents", parents)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.TrialComponent
  ) extends zio.aws.sagemaker.model.TrialComponent.ReadOnly {
    override val trialComponentName: Optional[ExperimentEntityName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trialComponentName())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ExperimentEntityName(value)
        )
    override val displayName: Optional[ExperimentEntityName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.displayName())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ExperimentEntityName(value)
        )
    override val trialComponentArn: Optional[TrialComponentArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trialComponentArn())
        .map(value =>
          zio.aws.sagemaker.model.primitives.TrialComponentArn(value)
        )
    override val source
        : Optional[zio.aws.sagemaker.model.TrialComponentSource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.source())
        .map(value => zio.aws.sagemaker.model.TrialComponentSource.wrap(value))
    override val status
        : Optional[zio.aws.sagemaker.model.TrialComponentStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.sagemaker.model.TrialComponentStatus.wrap(value))
    override val startTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val endTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val createdBy
        : Optional[zio.aws.sagemaker.model.UserContext.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdBy())
        .map(value => zio.aws.sagemaker.model.UserContext.wrap(value))
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedBy
        : Optional[zio.aws.sagemaker.model.UserContext.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedBy())
        .map(value => zio.aws.sagemaker.model.UserContext.wrap(value))
    override val parameters: Optional[Map[
      TrialComponentKey256,
      zio.aws.sagemaker.model.TrialComponentParameterValue.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.parameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.sagemaker.model.primitives.TrialComponentKey256(
              key
            ) -> zio.aws.sagemaker.model.TrialComponentParameterValue
              .wrap(value)
          })
          .toMap
      )
    override val inputArtifacts: Optional[Map[
      TrialComponentKey64,
      zio.aws.sagemaker.model.TrialComponentArtifact.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.inputArtifacts())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.sagemaker.model.primitives.TrialComponentKey64(
              key
            ) -> zio.aws.sagemaker.model.TrialComponentArtifact.wrap(value)
          })
          .toMap
      )
    override val outputArtifacts: Optional[Map[
      TrialComponentKey64,
      zio.aws.sagemaker.model.TrialComponentArtifact.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.outputArtifacts())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.sagemaker.model.primitives.TrialComponentKey64(
              key
            ) -> zio.aws.sagemaker.model.TrialComponentArtifact.wrap(value)
          })
          .toMap
      )
    override val metrics: Optional[
      List[zio.aws.sagemaker.model.TrialComponentMetricSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.metrics())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.TrialComponentMetricSummary.wrap(item)
        }.toList
      )
    override val metadataProperties
        : Optional[zio.aws.sagemaker.model.MetadataProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metadataProperties())
        .map(value => zio.aws.sagemaker.model.MetadataProperties.wrap(value))
    override val sourceDetail: Optional[
      zio.aws.sagemaker.model.TrialComponentSourceDetail.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceDetail())
      .map(value =>
        zio.aws.sagemaker.model.TrialComponentSourceDetail.wrap(value)
      )
    override val lineageGroupArn: Optional[LineageGroupArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lineageGroupArn())
        .map(value => zio.aws.sagemaker.model.primitives.LineageGroupArn(value))
    override val tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
    override val parents
        : Optional[List[zio.aws.sagemaker.model.Parent.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parents())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Parent.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.TrialComponent
  ): zio.aws.sagemaker.model.TrialComponent.ReadOnly = new Wrapper(impl)
}
