package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.NotebookInstanceName
import scala.jdk.CollectionConverters._
final case class StartNotebookInstanceRequest(
    notebookInstanceName: NotebookInstanceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.StartNotebookInstanceRequest = {
    import StartNotebookInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.StartNotebookInstanceRequest
      .builder()
      .notebookInstanceName(
        NotebookInstanceName.unwrap(notebookInstanceName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.StartNotebookInstanceRequest.ReadOnly =
    zio.aws.sagemaker.model.StartNotebookInstanceRequest.wrap(buildAwsValue())
}
object StartNotebookInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.StartNotebookInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.StartNotebookInstanceRequest =
      zio.aws.sagemaker.model.StartNotebookInstanceRequest(notebookInstanceName)
    def notebookInstanceName: NotebookInstanceName
    def getNotebookInstanceName: ZIO[Any, Nothing, NotebookInstanceName] =
      ZIO.succeed(notebookInstanceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.StartNotebookInstanceRequest
  ) extends zio.aws.sagemaker.model.StartNotebookInstanceRequest.ReadOnly {
    override val notebookInstanceName: NotebookInstanceName =
      zio.aws.sagemaker.model.primitives
        .NotebookInstanceName(impl.notebookInstanceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.StartNotebookInstanceRequest
  ): zio.aws.sagemaker.model.StartNotebookInstanceRequest.ReadOnly =
    new Wrapper(impl)
}
