package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait ModelApprovalStatus {
  def unwrap
      : software.amazon.awssdk.services.sagemaker.model.ModelApprovalStatus
}
object ModelApprovalStatus {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.ModelApprovalStatus
  ): zio.aws.sagemaker.model.ModelApprovalStatus = value match {
    case software.amazon.awssdk.services.sagemaker.model.ModelApprovalStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.ModelApprovalStatus.APPROVED =>
      val r = Approved
      r
    case software.amazon.awssdk.services.sagemaker.model.ModelApprovalStatus.REJECTED =>
      val r = Rejected
      r
    case software.amazon.awssdk.services.sagemaker.model.ModelApprovalStatus.PENDING_MANUAL_APPROVAL =>
      val r = PendingManualApproval
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.ModelApprovalStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelApprovalStatus =
      software.amazon.awssdk.services.sagemaker.model.ModelApprovalStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Approved extends zio.aws.sagemaker.model.ModelApprovalStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelApprovalStatus =
      software.amazon.awssdk.services.sagemaker.model.ModelApprovalStatus.APPROVED
  }
  case object Rejected extends zio.aws.sagemaker.model.ModelApprovalStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelApprovalStatus =
      software.amazon.awssdk.services.sagemaker.model.ModelApprovalStatus.REJECTED
  }
  case object PendingManualApproval
      extends zio.aws.sagemaker.model.ModelApprovalStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelApprovalStatus =
      software.amazon.awssdk.services.sagemaker.model.ModelApprovalStatus.PENDING_MANUAL_APPROVAL
  }
}
