package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.{DirectoryPath, FileSystemId}
import scala.jdk.CollectionConverters._
final case class FileSystemDataSource(
    fileSystemId: FileSystemId,
    fileSystemAccessMode: zio.aws.sagemaker.model.FileSystemAccessMode,
    fileSystemType: zio.aws.sagemaker.model.FileSystemType,
    directoryPath: DirectoryPath
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.FileSystemDataSource = {
    import FileSystemDataSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.FileSystemDataSource
      .builder()
      .fileSystemId(FileSystemId.unwrap(fileSystemId): java.lang.String)
      .fileSystemAccessMode(fileSystemAccessMode.unwrap)
      .fileSystemType(fileSystemType.unwrap)
      .directoryPath(DirectoryPath.unwrap(directoryPath): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.FileSystemDataSource.ReadOnly =
    zio.aws.sagemaker.model.FileSystemDataSource.wrap(buildAwsValue())
}
object FileSystemDataSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.FileSystemDataSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.FileSystemDataSource =
      zio.aws.sagemaker.model.FileSystemDataSource(
        fileSystemId,
        fileSystemAccessMode,
        fileSystemType,
        directoryPath
      )
    def fileSystemId: FileSystemId
    def fileSystemAccessMode: zio.aws.sagemaker.model.FileSystemAccessMode
    def fileSystemType: zio.aws.sagemaker.model.FileSystemType
    def directoryPath: DirectoryPath
    def getFileSystemId: ZIO[Any, Nothing, FileSystemId] =
      ZIO.succeed(fileSystemId)
    def getFileSystemAccessMode
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.FileSystemAccessMode] =
      ZIO.succeed(fileSystemAccessMode)
    def getFileSystemType
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.FileSystemType] =
      ZIO.succeed(fileSystemType)
    def getDirectoryPath: ZIO[Any, Nothing, DirectoryPath] =
      ZIO.succeed(directoryPath)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.FileSystemDataSource
  ) extends zio.aws.sagemaker.model.FileSystemDataSource.ReadOnly {
    override val fileSystemId: FileSystemId =
      zio.aws.sagemaker.model.primitives.FileSystemId(impl.fileSystemId())
    override val fileSystemAccessMode
        : zio.aws.sagemaker.model.FileSystemAccessMode =
      zio.aws.sagemaker.model.FileSystemAccessMode
        .wrap(impl.fileSystemAccessMode())
    override val fileSystemType: zio.aws.sagemaker.model.FileSystemType =
      zio.aws.sagemaker.model.FileSystemType.wrap(impl.fileSystemType())
    override val directoryPath: DirectoryPath =
      zio.aws.sagemaker.model.primitives.DirectoryPath(impl.directoryPath())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.FileSystemDataSource
  ): zio.aws.sagemaker.model.FileSystemDataSource.ReadOnly = new Wrapper(impl)
}
