package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  EndpointName,
  Timestamp,
  FailureReason,
  EndpointArn,
  EndpointConfigName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeEndpointResponse(
    endpointName: EndpointName,
    endpointArn: EndpointArn,
    endpointConfigName: EndpointConfigName,
    productionVariants: Optional[
      Iterable[zio.aws.sagemaker.model.ProductionVariantSummary]
    ] = Optional.Absent,
    dataCaptureConfig: Optional[
      zio.aws.sagemaker.model.DataCaptureConfigSummary
    ] = Optional.Absent,
    endpointStatus: zio.aws.sagemaker.model.EndpointStatus,
    failureReason: Optional[FailureReason] = Optional.Absent,
    creationTime: Timestamp,
    lastModifiedTime: Timestamp,
    lastDeploymentConfig: Optional[zio.aws.sagemaker.model.DeploymentConfig] =
      Optional.Absent,
    asyncInferenceConfig: Optional[
      zio.aws.sagemaker.model.AsyncInferenceConfig
    ] = Optional.Absent,
    pendingDeploymentSummary: Optional[
      zio.aws.sagemaker.model.PendingDeploymentSummary
    ] = Optional.Absent,
    explainerConfig: Optional[zio.aws.sagemaker.model.ExplainerConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeEndpointResponse = {
    import DescribeEndpointResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeEndpointResponse
      .builder()
      .endpointName(EndpointName.unwrap(endpointName): java.lang.String)
      .endpointArn(EndpointArn.unwrap(endpointArn): java.lang.String)
      .endpointConfigName(
        EndpointConfigName.unwrap(endpointConfigName): java.lang.String
      )
      .optionallyWith(
        productionVariants.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.productionVariants)
      .optionallyWith(dataCaptureConfig.map(value => value.buildAwsValue()))(
        _.dataCaptureConfig
      )
      .endpointStatus(endpointStatus.unwrap)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .lastModifiedTime(Timestamp.unwrap(lastModifiedTime): Instant)
      .optionallyWith(lastDeploymentConfig.map(value => value.buildAwsValue()))(
        _.lastDeploymentConfig
      )
      .optionallyWith(asyncInferenceConfig.map(value => value.buildAwsValue()))(
        _.asyncInferenceConfig
      )
      .optionallyWith(
        pendingDeploymentSummary.map(value => value.buildAwsValue())
      )(_.pendingDeploymentSummary)
      .optionallyWith(explainerConfig.map(value => value.buildAwsValue()))(
        _.explainerConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeEndpointResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeEndpointResponse.wrap(buildAwsValue())
}
object DescribeEndpointResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeEndpointResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeEndpointResponse =
      zio.aws.sagemaker.model.DescribeEndpointResponse(
        endpointName,
        endpointArn,
        endpointConfigName,
        productionVariants.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dataCaptureConfig.map(value => value.asEditable),
        endpointStatus,
        failureReason.map(value => value),
        creationTime,
        lastModifiedTime,
        lastDeploymentConfig.map(value => value.asEditable),
        asyncInferenceConfig.map(value => value.asEditable),
        pendingDeploymentSummary.map(value => value.asEditable),
        explainerConfig.map(value => value.asEditable)
      )
    def endpointName: EndpointName
    def endpointArn: EndpointArn
    def endpointConfigName: EndpointConfigName
    def productionVariants: Optional[
      List[zio.aws.sagemaker.model.ProductionVariantSummary.ReadOnly]
    ]
    def dataCaptureConfig
        : Optional[zio.aws.sagemaker.model.DataCaptureConfigSummary.ReadOnly]
    def endpointStatus: zio.aws.sagemaker.model.EndpointStatus
    def failureReason: Optional[FailureReason]
    def creationTime: Timestamp
    def lastModifiedTime: Timestamp
    def lastDeploymentConfig
        : Optional[zio.aws.sagemaker.model.DeploymentConfig.ReadOnly]
    def asyncInferenceConfig
        : Optional[zio.aws.sagemaker.model.AsyncInferenceConfig.ReadOnly]
    def pendingDeploymentSummary
        : Optional[zio.aws.sagemaker.model.PendingDeploymentSummary.ReadOnly]
    def explainerConfig
        : Optional[zio.aws.sagemaker.model.ExplainerConfig.ReadOnly]
    def getEndpointName: ZIO[Any, Nothing, EndpointName] =
      ZIO.succeed(endpointName)
    def getEndpointArn: ZIO[Any, Nothing, EndpointArn] =
      ZIO.succeed(endpointArn)
    def getEndpointConfigName: ZIO[Any, Nothing, EndpointConfigName] =
      ZIO.succeed(endpointConfigName)
    def getProductionVariants: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.ProductionVariantSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("productionVariants", productionVariants)
    def getDataCaptureConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.DataCaptureConfigSummary.ReadOnly
    ] = AwsError.unwrapOptionField("dataCaptureConfig", dataCaptureConfig)
    def getEndpointStatus
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.EndpointStatus] =
      ZIO.succeed(endpointStatus)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getLastModifiedTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModifiedTime)
    def getLastDeploymentConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.DeploymentConfig.ReadOnly
    ] = AwsError.unwrapOptionField("lastDeploymentConfig", lastDeploymentConfig)
    def getAsyncInferenceConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.AsyncInferenceConfig.ReadOnly
    ] = AwsError.unwrapOptionField("asyncInferenceConfig", asyncInferenceConfig)
    def getPendingDeploymentSummary: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.PendingDeploymentSummary.ReadOnly
    ] = AwsError.unwrapOptionField(
      "pendingDeploymentSummary",
      pendingDeploymentSummary
    )
    def getExplainerConfig
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ExplainerConfig.ReadOnly] =
      AwsError.unwrapOptionField("explainerConfig", explainerConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeEndpointResponse
  ) extends zio.aws.sagemaker.model.DescribeEndpointResponse.ReadOnly {
    override val endpointName: EndpointName =
      zio.aws.sagemaker.model.primitives.EndpointName(impl.endpointName())
    override val endpointArn: EndpointArn =
      zio.aws.sagemaker.model.primitives.EndpointArn(impl.endpointArn())
    override val endpointConfigName: EndpointConfigName =
      zio.aws.sagemaker.model.primitives
        .EndpointConfigName(impl.endpointConfigName())
    override val productionVariants: Optional[
      List[zio.aws.sagemaker.model.ProductionVariantSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.productionVariants())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.ProductionVariantSummary.wrap(item)
        }.toList
      )
    override val dataCaptureConfig
        : Optional[zio.aws.sagemaker.model.DataCaptureConfigSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataCaptureConfig())
        .map(value =>
          zio.aws.sagemaker.model.DataCaptureConfigSummary.wrap(value)
        )
    override val endpointStatus: zio.aws.sagemaker.model.EndpointStatus =
      zio.aws.sagemaker.model.EndpointStatus.wrap(impl.endpointStatus())
    override val failureReason: Optional[FailureReason] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => zio.aws.sagemaker.model.primitives.FailureReason(value))
    override val creationTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.creationTime())
    override val lastModifiedTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.lastModifiedTime())
    override val lastDeploymentConfig
        : Optional[zio.aws.sagemaker.model.DeploymentConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastDeploymentConfig())
        .map(value => zio.aws.sagemaker.model.DeploymentConfig.wrap(value))
    override val asyncInferenceConfig
        : Optional[zio.aws.sagemaker.model.AsyncInferenceConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.asyncInferenceConfig())
        .map(value => zio.aws.sagemaker.model.AsyncInferenceConfig.wrap(value))
    override val pendingDeploymentSummary
        : Optional[zio.aws.sagemaker.model.PendingDeploymentSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pendingDeploymentSummary())
        .map(value =>
          zio.aws.sagemaker.model.PendingDeploymentSummary.wrap(value)
        )
    override val explainerConfig
        : Optional[zio.aws.sagemaker.model.ExplainerConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.explainerConfig())
        .map(value => zio.aws.sagemaker.model.ExplainerConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeEndpointResponse
  ): zio.aws.sagemaker.model.DescribeEndpointResponse.ReadOnly = new Wrapper(
    impl
  )
}
