package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.TrainingJobName
import scala.jdk.CollectionConverters._
final case class UpdateTrainingJobRequest(
    trainingJobName: TrainingJobName,
    profilerConfig: Optional[zio.aws.sagemaker.model.ProfilerConfigForUpdate] =
      Optional.Absent,
    profilerRuleConfigurations: Optional[
      Iterable[zio.aws.sagemaker.model.ProfilerRuleConfiguration]
    ] = Optional.Absent,
    resourceConfig: Optional[zio.aws.sagemaker.model.ResourceConfigForUpdate] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdateTrainingJobRequest = {
    import UpdateTrainingJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdateTrainingJobRequest
      .builder()
      .trainingJobName(
        TrainingJobName.unwrap(trainingJobName): java.lang.String
      )
      .optionallyWith(profilerConfig.map(value => value.buildAwsValue()))(
        _.profilerConfig
      )
      .optionallyWith(
        profilerRuleConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.profilerRuleConfigurations)
      .optionallyWith(resourceConfig.map(value => value.buildAwsValue()))(
        _.resourceConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.UpdateTrainingJobRequest.ReadOnly =
    zio.aws.sagemaker.model.UpdateTrainingJobRequest.wrap(buildAwsValue())
}
object UpdateTrainingJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdateTrainingJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UpdateTrainingJobRequest =
      zio.aws.sagemaker.model.UpdateTrainingJobRequest(
        trainingJobName,
        profilerConfig.map(value => value.asEditable),
        profilerRuleConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceConfig.map(value => value.asEditable)
      )
    def trainingJobName: TrainingJobName
    def profilerConfig
        : Optional[zio.aws.sagemaker.model.ProfilerConfigForUpdate.ReadOnly]
    def profilerRuleConfigurations: Optional[
      List[zio.aws.sagemaker.model.ProfilerRuleConfiguration.ReadOnly]
    ]
    def resourceConfig
        : Optional[zio.aws.sagemaker.model.ResourceConfigForUpdate.ReadOnly]
    def getTrainingJobName: ZIO[Any, Nothing, TrainingJobName] =
      ZIO.succeed(trainingJobName)
    def getProfilerConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ProfilerConfigForUpdate.ReadOnly
    ] = AwsError.unwrapOptionField("profilerConfig", profilerConfig)
    def getProfilerRuleConfigurations: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.ProfilerRuleConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "profilerRuleConfigurations",
      profilerRuleConfigurations
    )
    def getResourceConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ResourceConfigForUpdate.ReadOnly
    ] = AwsError.unwrapOptionField("resourceConfig", resourceConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateTrainingJobRequest
  ) extends zio.aws.sagemaker.model.UpdateTrainingJobRequest.ReadOnly {
    override val trainingJobName: TrainingJobName =
      zio.aws.sagemaker.model.primitives.TrainingJobName(impl.trainingJobName())
    override val profilerConfig
        : Optional[zio.aws.sagemaker.model.ProfilerConfigForUpdate.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.profilerConfig())
        .map(value =>
          zio.aws.sagemaker.model.ProfilerConfigForUpdate.wrap(value)
        )
    override val profilerRuleConfigurations: Optional[
      List[zio.aws.sagemaker.model.ProfilerRuleConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.profilerRuleConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.ProfilerRuleConfiguration.wrap(item)
        }.toList
      )
    override val resourceConfig
        : Optional[zio.aws.sagemaker.model.ResourceConfigForUpdate.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceConfig())
        .map(value =>
          zio.aws.sagemaker.model.ResourceConfigForUpdate.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateTrainingJobRequest
  ): zio.aws.sagemaker.model.UpdateTrainingJobRequest.ReadOnly = new Wrapper(
    impl
  )
}
