package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListTrainingJobsResponse(
    trainingJobSummaries: Iterable[zio.aws.sagemaker.model.TrainingJobSummary],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsResponse = {
    import ListTrainingJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsResponse
      .builder()
      .trainingJobSummaries(trainingJobSummaries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListTrainingJobsResponse.ReadOnly =
    zio.aws.sagemaker.model.ListTrainingJobsResponse.wrap(buildAwsValue())
}
object ListTrainingJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListTrainingJobsResponse =
      zio.aws.sagemaker.model.ListTrainingJobsResponse(
        trainingJobSummaries.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def trainingJobSummaries
        : List[zio.aws.sagemaker.model.TrainingJobSummary.ReadOnly]
    def nextToken: Optional[NextToken]
    def getTrainingJobSummaries: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.TrainingJobSummary.ReadOnly
    ]] = ZIO.succeed(trainingJobSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsResponse
  ) extends zio.aws.sagemaker.model.ListTrainingJobsResponse.ReadOnly {
    override val trainingJobSummaries
        : List[zio.aws.sagemaker.model.TrainingJobSummary.ReadOnly] = impl
      .trainingJobSummaries()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.TrainingJobSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsResponse
  ): zio.aws.sagemaker.model.ListTrainingJobsResponse.ReadOnly = new Wrapper(
    impl
  )
}
