package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  ListTagsMaxResults,
  NextToken,
  ResourceArn
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListTagsRequest(
    resourceArn: ResourceArn,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[ListTagsMaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListTagsRequest = {
    import ListTagsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListTagsRequest
      .builder()
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => ListTagsMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListTagsRequest.ReadOnly =
    zio.aws.sagemaker.model.ListTagsRequest.wrap(buildAwsValue())
}
object ListTagsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListTagsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListTagsRequest =
      zio.aws.sagemaker.model.ListTagsRequest(
        resourceArn,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def resourceArn: ResourceArn
    def nextToken: Optional[NextToken]
    def maxResults: Optional[ListTagsMaxResults]
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ListTagsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListTagsRequest
  ) extends zio.aws.sagemaker.model.ListTagsRequest.ReadOnly {
    override val resourceArn: ResourceArn =
      zio.aws.sagemaker.model.primitives.ResourceArn(impl.resourceArn())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val maxResults: Optional[ListTagsMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ListTagsMaxResults(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListTagsRequest
  ): zio.aws.sagemaker.model.ListTagsRequest.ReadOnly = new Wrapper(impl)
}
