package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  MaxResults,
  NextToken,
  PipelineExecutionArn
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListPipelineParametersForExecutionRequest(
    pipelineExecutionArn: PipelineExecutionArn,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListPipelineParametersForExecutionRequest = {
    import ListPipelineParametersForExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListPipelineParametersForExecutionRequest
      .builder()
      .pipelineExecutionArn(
        PipelineExecutionArn.unwrap(pipelineExecutionArn): java.lang.String
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ListPipelineParametersForExecutionRequest.ReadOnly =
    zio.aws.sagemaker.model.ListPipelineParametersForExecutionRequest
      .wrap(buildAwsValue())
}
object ListPipelineParametersForExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListPipelineParametersForExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.ListPipelineParametersForExecutionRequest =
      zio.aws.sagemaker.model.ListPipelineParametersForExecutionRequest(
        pipelineExecutionArn,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def pipelineExecutionArn: PipelineExecutionArn
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getPipelineExecutionArn: ZIO[Any, Nothing, PipelineExecutionArn] =
      ZIO.succeed(pipelineExecutionArn)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListPipelineParametersForExecutionRequest
  ) extends zio.aws.sagemaker.model.ListPipelineParametersForExecutionRequest.ReadOnly {
    override val pipelineExecutionArn: PipelineExecutionArn =
      zio.aws.sagemaker.model.primitives
        .PipelineExecutionArn(impl.pipelineExecutionArn())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListPipelineParametersForExecutionRequest
  ): zio.aws.sagemaker.model.ListPipelineParametersForExecutionRequest.ReadOnly =
    new Wrapper(impl)
}
