package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait Framework {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.Framework
}
object Framework {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.Framework
  ): zio.aws.sagemaker.model.Framework = value match {
    case software.amazon.awssdk.services.sagemaker.model.Framework.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.Framework.TENSORFLOW =>
      val r = TENSORFLOW
      r
    case software.amazon.awssdk.services.sagemaker.model.Framework.KERAS =>
      val r = KERAS
      r
    case software.amazon.awssdk.services.sagemaker.model.Framework.MXNET =>
      val r = MXNET
      r
    case software.amazon.awssdk.services.sagemaker.model.Framework.ONNX =>
      val r = ONNX
      r
    case software.amazon.awssdk.services.sagemaker.model.Framework.PYTORCH =>
      val r = PYTORCH
      r
    case software.amazon.awssdk.services.sagemaker.model.Framework.XGBOOST =>
      val r = XGBOOST
      r
    case software.amazon.awssdk.services.sagemaker.model.Framework.TFLITE =>
      val r = TFLITE
      r
    case software.amazon.awssdk.services.sagemaker.model.Framework.DARKNET =>
      val r = DARKNET
      r
    case software.amazon.awssdk.services.sagemaker.model.Framework.SKLEARN =>
      val r = SKLEARN
      r
  }
  case object unknownToSdkVersion extends zio.aws.sagemaker.model.Framework {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.Framework =
      software.amazon.awssdk.services.sagemaker.model.Framework.UNKNOWN_TO_SDK_VERSION
  }
  case object TENSORFLOW extends zio.aws.sagemaker.model.Framework {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.Framework =
      software.amazon.awssdk.services.sagemaker.model.Framework.TENSORFLOW
  }
  case object KERAS extends zio.aws.sagemaker.model.Framework {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.Framework =
      software.amazon.awssdk.services.sagemaker.model.Framework.KERAS
  }
  case object MXNET extends zio.aws.sagemaker.model.Framework {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.Framework =
      software.amazon.awssdk.services.sagemaker.model.Framework.MXNET
  }
  case object ONNX extends zio.aws.sagemaker.model.Framework {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.Framework =
      software.amazon.awssdk.services.sagemaker.model.Framework.ONNX
  }
  case object PYTORCH extends zio.aws.sagemaker.model.Framework {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.Framework =
      software.amazon.awssdk.services.sagemaker.model.Framework.PYTORCH
  }
  case object XGBOOST extends zio.aws.sagemaker.model.Framework {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.Framework =
      software.amazon.awssdk.services.sagemaker.model.Framework.XGBOOST
  }
  case object TFLITE extends zio.aws.sagemaker.model.Framework {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.Framework =
      software.amazon.awssdk.services.sagemaker.model.Framework.TFLITE
  }
  case object DARKNET extends zio.aws.sagemaker.model.Framework {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.Framework =
      software.amazon.awssdk.services.sagemaker.model.Framework.DARKNET
  }
  case object SKLEARN extends zio.aws.sagemaker.model.Framework {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.Framework =
      software.amazon.awssdk.services.sagemaker.model.Framework.SKLEARN
  }
}
