package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeWorkforceResponse(
    workforce: zio.aws.sagemaker.model.Workforce
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeWorkforceResponse = {
    import DescribeWorkforceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeWorkforceResponse
      .builder()
      .workforce(workforce.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeWorkforceResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeWorkforceResponse.wrap(buildAwsValue())
}
object DescribeWorkforceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeWorkforceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeWorkforceResponse =
      zio.aws.sagemaker.model.DescribeWorkforceResponse(workforce.asEditable)
    def workforce: zio.aws.sagemaker.model.Workforce.ReadOnly
    def getWorkforce
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.Workforce.ReadOnly] =
      ZIO.succeed(workforce)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeWorkforceResponse
  ) extends zio.aws.sagemaker.model.DescribeWorkforceResponse.ReadOnly {
    override val workforce: zio.aws.sagemaker.model.Workforce.ReadOnly =
      zio.aws.sagemaker.model.Workforce.wrap(impl.workforce())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeWorkforceResponse
  ): zio.aws.sagemaker.model.DescribeWorkforceResponse.ReadOnly = new Wrapper(
    impl
  )
}
