package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{
  ContentType,
  EntityDescription,
  ChannelName
}
import scala.jdk.CollectionConverters._
final case class ChannelSpecification(
    name: ChannelName,
    description: Optional[EntityDescription] = Optional.Absent,
    isRequired: Optional[Boolean] = Optional.Absent,
    supportedContentTypes: Iterable[ContentType],
    supportedCompressionTypes: Optional[
      Iterable[zio.aws.sagemaker.model.CompressionType]
    ] = Optional.Absent,
    supportedInputModes: Iterable[zio.aws.sagemaker.model.TrainingInputMode]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ChannelSpecification = {
    import ChannelSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ChannelSpecification
      .builder()
      .name(ChannelName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          EntityDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(isRequired.map(value => value: java.lang.Boolean))(
        _.isRequired
      )
      .supportedContentTypes(supportedContentTypes.map { item =>
        ContentType.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        supportedCompressionTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.supportedCompressionTypesWithStrings)
      .supportedInputModesWithStrings(supportedInputModes.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ChannelSpecification.ReadOnly =
    zio.aws.sagemaker.model.ChannelSpecification.wrap(buildAwsValue())
}
object ChannelSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ChannelSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ChannelSpecification =
      zio.aws.sagemaker.model.ChannelSpecification(
        name,
        description.map(value => value),
        isRequired.map(value => value),
        supportedContentTypes,
        supportedCompressionTypes.map(value => value),
        supportedInputModes
      )
    def name: ChannelName
    def description: Optional[EntityDescription]
    def isRequired: Optional[Boolean]
    def supportedContentTypes: List[ContentType]
    def supportedCompressionTypes
        : Optional[List[zio.aws.sagemaker.model.CompressionType]]
    def supportedInputModes: List[zio.aws.sagemaker.model.TrainingInputMode]
    def getName: ZIO[Any, Nothing, ChannelName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, EntityDescription] =
      AwsError.unwrapOptionField("description", description)
    def getIsRequired: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isRequired", isRequired)
    def getSupportedContentTypes: ZIO[Any, Nothing, List[ContentType]] =
      ZIO.succeed(supportedContentTypes)
    def getSupportedCompressionTypes
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.CompressionType]] =
      AwsError.unwrapOptionField(
        "supportedCompressionTypes",
        supportedCompressionTypes
      )
    def getSupportedInputModes
        : ZIO[Any, Nothing, List[zio.aws.sagemaker.model.TrainingInputMode]] =
      ZIO.succeed(supportedInputModes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ChannelSpecification
  ) extends zio.aws.sagemaker.model.ChannelSpecification.ReadOnly {
    override val name: ChannelName =
      zio.aws.sagemaker.model.primitives.ChannelName(impl.name())
    override val description: Optional[EntityDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.sagemaker.model.primitives.EntityDescription(value)
        )
    override val isRequired: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isRequired())
      .map(value => value: Boolean)
    override val supportedContentTypes: List[ContentType] = impl
      .supportedContentTypes()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.primitives.ContentType(item)
      }
      .toList
    override val supportedCompressionTypes
        : Optional[List[zio.aws.sagemaker.model.CompressionType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportedCompressionTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.CompressionType.wrap(item)
          }.toList
        )
    override val supportedInputModes
        : List[zio.aws.sagemaker.model.TrainingInputMode] = impl
      .supportedInputModes()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.TrainingInputMode.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ChannelSpecification
  ): zio.aws.sagemaker.model.ChannelSpecification.ReadOnly = new Wrapper(impl)
}
