package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.PipelineExecutionArn
import scala.jdk.CollectionConverters._
final case class RetryPipelineExecutionResponse(
    pipelineExecutionArn: Optional[PipelineExecutionArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.RetryPipelineExecutionResponse = {
    import RetryPipelineExecutionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.RetryPipelineExecutionResponse
      .builder()
      .optionallyWith(
        pipelineExecutionArn.map(value =>
          PipelineExecutionArn.unwrap(value): java.lang.String
        )
      )(_.pipelineExecutionArn)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.RetryPipelineExecutionResponse.ReadOnly =
    zio.aws.sagemaker.model.RetryPipelineExecutionResponse.wrap(buildAwsValue())
}
object RetryPipelineExecutionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.RetryPipelineExecutionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.RetryPipelineExecutionResponse =
      zio.aws.sagemaker.model.RetryPipelineExecutionResponse(
        pipelineExecutionArn.map(value => value)
      )
    def pipelineExecutionArn: Optional[PipelineExecutionArn]
    def getPipelineExecutionArn: ZIO[Any, AwsError, PipelineExecutionArn] =
      AwsError.unwrapOptionField("pipelineExecutionArn", pipelineExecutionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.RetryPipelineExecutionResponse
  ) extends zio.aws.sagemaker.model.RetryPipelineExecutionResponse.ReadOnly {
    override val pipelineExecutionArn: Optional[PipelineExecutionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pipelineExecutionArn())
        .map(value =>
          zio.aws.sagemaker.model.primitives.PipelineExecutionArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.RetryPipelineExecutionResponse
  ): zio.aws.sagemaker.model.RetryPipelineExecutionResponse.ReadOnly =
    new Wrapper(impl)
}
