package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait ResourceType {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.ResourceType
}
object ResourceType {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.ResourceType
  ): zio.aws.sagemaker.model.ResourceType = value match {
    case software.amazon.awssdk.services.sagemaker.model.ResourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.ResourceType.TRAINING_JOB =>
      val r = TrainingJob
      r
    case software.amazon.awssdk.services.sagemaker.model.ResourceType.EXPERIMENT =>
      val r = Experiment
      r
    case software.amazon.awssdk.services.sagemaker.model.ResourceType.EXPERIMENT_TRIAL =>
      val r = ExperimentTrial
      r
    case software.amazon.awssdk.services.sagemaker.model.ResourceType.EXPERIMENT_TRIAL_COMPONENT =>
      val r = ExperimentTrialComponent
      r
    case software.amazon.awssdk.services.sagemaker.model.ResourceType.ENDPOINT =>
      val r = Endpoint
      r
    case software.amazon.awssdk.services.sagemaker.model.ResourceType.MODEL_PACKAGE =>
      val r = ModelPackage
      r
    case software.amazon.awssdk.services.sagemaker.model.ResourceType.MODEL_PACKAGE_GROUP =>
      val r = ModelPackageGroup
      r
    case software.amazon.awssdk.services.sagemaker.model.ResourceType.PIPELINE =>
      val r = Pipeline
      r
    case software.amazon.awssdk.services.sagemaker.model.ResourceType.PIPELINE_EXECUTION =>
      val r = PipelineExecution
      r
    case software.amazon.awssdk.services.sagemaker.model.ResourceType.FEATURE_GROUP =>
      val r = FeatureGroup
      r
    case software.amazon.awssdk.services.sagemaker.model.ResourceType.PROJECT =>
      val r = Project
      r
    case software.amazon.awssdk.services.sagemaker.model.ResourceType.FEATURE_METADATA =>
      val r = FeatureMetadata
      r
    case software.amazon.awssdk.services.sagemaker.model.ResourceType.HYPER_PARAMETER_TUNING_JOB =>
      val r = HyperParameterTuningJob
      r
  }
  case object unknownToSdkVersion extends zio.aws.sagemaker.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ResourceType =
      software.amazon.awssdk.services.sagemaker.model.ResourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object TrainingJob extends zio.aws.sagemaker.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ResourceType =
      software.amazon.awssdk.services.sagemaker.model.ResourceType.TRAINING_JOB
  }
  case object Experiment extends zio.aws.sagemaker.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ResourceType =
      software.amazon.awssdk.services.sagemaker.model.ResourceType.EXPERIMENT
  }
  case object ExperimentTrial extends zio.aws.sagemaker.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ResourceType =
      software.amazon.awssdk.services.sagemaker.model.ResourceType.EXPERIMENT_TRIAL
  }
  case object ExperimentTrialComponent
      extends zio.aws.sagemaker.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ResourceType =
      software.amazon.awssdk.services.sagemaker.model.ResourceType.EXPERIMENT_TRIAL_COMPONENT
  }
  case object Endpoint extends zio.aws.sagemaker.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ResourceType =
      software.amazon.awssdk.services.sagemaker.model.ResourceType.ENDPOINT
  }
  case object ModelPackage extends zio.aws.sagemaker.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ResourceType =
      software.amazon.awssdk.services.sagemaker.model.ResourceType.MODEL_PACKAGE
  }
  case object ModelPackageGroup extends zio.aws.sagemaker.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ResourceType =
      software.amazon.awssdk.services.sagemaker.model.ResourceType.MODEL_PACKAGE_GROUP
  }
  case object Pipeline extends zio.aws.sagemaker.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ResourceType =
      software.amazon.awssdk.services.sagemaker.model.ResourceType.PIPELINE
  }
  case object PipelineExecution extends zio.aws.sagemaker.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ResourceType =
      software.amazon.awssdk.services.sagemaker.model.ResourceType.PIPELINE_EXECUTION
  }
  case object FeatureGroup extends zio.aws.sagemaker.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ResourceType =
      software.amazon.awssdk.services.sagemaker.model.ResourceType.FEATURE_GROUP
  }
  case object Project extends zio.aws.sagemaker.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ResourceType =
      software.amazon.awssdk.services.sagemaker.model.ResourceType.PROJECT
  }
  case object FeatureMetadata extends zio.aws.sagemaker.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ResourceType =
      software.amazon.awssdk.services.sagemaker.model.ResourceType.FEATURE_METADATA
  }
  case object HyperParameterTuningJob
      extends zio.aws.sagemaker.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ResourceType =
      software.amazon.awssdk.services.sagemaker.model.ResourceType.HYPER_PARAMETER_TUNING_JOB
  }
}
