package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.EntityName
import scala.jdk.CollectionConverters._
final case class DescribeEdgePackagingJobRequest(
    edgePackagingJobName: EntityName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeEdgePackagingJobRequest = {
    import DescribeEdgePackagingJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeEdgePackagingJobRequest
      .builder()
      .edgePackagingJobName(
        EntityName.unwrap(edgePackagingJobName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribeEdgePackagingJobRequest.ReadOnly =
    zio.aws.sagemaker.model.DescribeEdgePackagingJobRequest
      .wrap(buildAwsValue())
}
object DescribeEdgePackagingJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeEdgePackagingJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeEdgePackagingJobRequest =
      zio.aws.sagemaker.model
        .DescribeEdgePackagingJobRequest(edgePackagingJobName)
    def edgePackagingJobName: EntityName
    def getEdgePackagingJobName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(edgePackagingJobName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeEdgePackagingJobRequest
  ) extends zio.aws.sagemaker.model.DescribeEdgePackagingJobRequest.ReadOnly {
    override val edgePackagingJobName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.edgePackagingJobName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeEdgePackagingJobRequest
  ): zio.aws.sagemaker.model.DescribeEdgePackagingJobRequest.ReadOnly =
    new Wrapper(impl)
}
