package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.EntityName
import scala.jdk.CollectionConverters._
final case class DeploymentStageStatusSummary(
    stageName: EntityName,
    deviceSelectionConfig: zio.aws.sagemaker.model.DeviceSelectionConfig,
    deploymentConfig: zio.aws.sagemaker.model.EdgeDeploymentConfig,
    deploymentStatus: zio.aws.sagemaker.model.EdgeDeploymentStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeploymentStageStatusSummary = {
    import DeploymentStageStatusSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeploymentStageStatusSummary
      .builder()
      .stageName(EntityName.unwrap(stageName): java.lang.String)
      .deviceSelectionConfig(deviceSelectionConfig.buildAwsValue())
      .deploymentConfig(deploymentConfig.buildAwsValue())
      .deploymentStatus(deploymentStatus.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DeploymentStageStatusSummary.ReadOnly =
    zio.aws.sagemaker.model.DeploymentStageStatusSummary.wrap(buildAwsValue())
}
object DeploymentStageStatusSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeploymentStageStatusSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DeploymentStageStatusSummary =
      zio.aws.sagemaker.model.DeploymentStageStatusSummary(
        stageName,
        deviceSelectionConfig.asEditable,
        deploymentConfig.asEditable,
        deploymentStatus.asEditable
      )
    def stageName: EntityName
    def deviceSelectionConfig
        : zio.aws.sagemaker.model.DeviceSelectionConfig.ReadOnly
    def deploymentConfig: zio.aws.sagemaker.model.EdgeDeploymentConfig.ReadOnly
    def deploymentStatus: zio.aws.sagemaker.model.EdgeDeploymentStatus.ReadOnly
    def getStageName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(stageName)
    def getDeviceSelectionConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.DeviceSelectionConfig.ReadOnly
    ] = ZIO.succeed(deviceSelectionConfig)
    def getDeploymentConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.EdgeDeploymentConfig.ReadOnly
    ] = ZIO.succeed(deploymentConfig)
    def getDeploymentStatus: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.EdgeDeploymentStatus.ReadOnly
    ] = ZIO.succeed(deploymentStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeploymentStageStatusSummary
  ) extends zio.aws.sagemaker.model.DeploymentStageStatusSummary.ReadOnly {
    override val stageName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.stageName())
    override val deviceSelectionConfig
        : zio.aws.sagemaker.model.DeviceSelectionConfig.ReadOnly =
      zio.aws.sagemaker.model.DeviceSelectionConfig
        .wrap(impl.deviceSelectionConfig())
    override val deploymentConfig
        : zio.aws.sagemaker.model.EdgeDeploymentConfig.ReadOnly =
      zio.aws.sagemaker.model.EdgeDeploymentConfig.wrap(impl.deploymentConfig())
    override val deploymentStatus
        : zio.aws.sagemaker.model.EdgeDeploymentStatus.ReadOnly =
      zio.aws.sagemaker.model.EdgeDeploymentStatus.wrap(impl.deploymentStatus())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeploymentStageStatusSummary
  ): zio.aws.sagemaker.model.DeploymentStageStatusSummary.ReadOnly =
    new Wrapper(impl)
}
