package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{Timestamp, ContainerImage}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DeployedImage(
    specifiedImage: Optional[ContainerImage] = Optional.Absent,
    resolvedImage: Optional[ContainerImage] = Optional.Absent,
    resolutionTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeployedImage = {
    import DeployedImage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeployedImage
      .builder()
      .optionallyWith(
        specifiedImage.map(value =>
          ContainerImage.unwrap(value): java.lang.String
        )
      )(_.specifiedImage)
      .optionallyWith(
        resolvedImage.map(value =>
          ContainerImage.unwrap(value): java.lang.String
        )
      )(_.resolvedImage)
      .optionallyWith(
        resolutionTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.resolutionTime)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DeployedImage.ReadOnly =
    zio.aws.sagemaker.model.DeployedImage.wrap(buildAwsValue())
}
object DeployedImage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeployedImage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DeployedImage =
      zio.aws.sagemaker.model.DeployedImage(
        specifiedImage.map(value => value),
        resolvedImage.map(value => value),
        resolutionTime.map(value => value)
      )
    def specifiedImage: Optional[ContainerImage]
    def resolvedImage: Optional[ContainerImage]
    def resolutionTime: Optional[Timestamp]
    def getSpecifiedImage: ZIO[Any, AwsError, ContainerImage] =
      AwsError.unwrapOptionField("specifiedImage", specifiedImage)
    def getResolvedImage: ZIO[Any, AwsError, ContainerImage] =
      AwsError.unwrapOptionField("resolvedImage", resolvedImage)
    def getResolutionTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("resolutionTime", resolutionTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeployedImage
  ) extends zio.aws.sagemaker.model.DeployedImage.ReadOnly {
    override val specifiedImage: Optional[ContainerImage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.specifiedImage())
        .map(value => zio.aws.sagemaker.model.primitives.ContainerImage(value))
    override val resolvedImage: Optional[ContainerImage] = zio.aws.core.internal
      .optionalFromNullable(impl.resolvedImage())
      .map(value => zio.aws.sagemaker.model.primitives.ContainerImage(value))
    override val resolutionTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.resolutionTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeployedImage
  ): zio.aws.sagemaker.model.DeployedImage.ReadOnly = new Wrapper(impl)
}
