package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.StudioLifecycleConfigArn
import scala.jdk.CollectionConverters._
final case class CreateStudioLifecycleConfigResponse(
    studioLifecycleConfigArn: Optional[StudioLifecycleConfigArn] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateStudioLifecycleConfigResponse = {
    import CreateStudioLifecycleConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateStudioLifecycleConfigResponse
      .builder()
      .optionallyWith(
        studioLifecycleConfigArn.map(value =>
          StudioLifecycleConfigArn.unwrap(value): java.lang.String
        )
      )(_.studioLifecycleConfigArn)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.CreateStudioLifecycleConfigResponse.ReadOnly =
    zio.aws.sagemaker.model.CreateStudioLifecycleConfigResponse
      .wrap(buildAwsValue())
}
object CreateStudioLifecycleConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateStudioLifecycleConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.CreateStudioLifecycleConfigResponse =
      zio.aws.sagemaker.model.CreateStudioLifecycleConfigResponse(
        studioLifecycleConfigArn.map(value => value)
      )
    def studioLifecycleConfigArn: Optional[StudioLifecycleConfigArn]
    def getStudioLifecycleConfigArn
        : ZIO[Any, AwsError, StudioLifecycleConfigArn] = AwsError
      .unwrapOptionField("studioLifecycleConfigArn", studioLifecycleConfigArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateStudioLifecycleConfigResponse
  ) extends zio.aws.sagemaker.model.CreateStudioLifecycleConfigResponse.ReadOnly {
    override val studioLifecycleConfigArn: Optional[StudioLifecycleConfigArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.studioLifecycleConfigArn())
        .map(value =>
          zio.aws.sagemaker.model.primitives.StudioLifecycleConfigArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateStudioLifecycleConfigResponse
  ): zio.aws.sagemaker.model.CreateStudioLifecycleConfigResponse.ReadOnly =
    new Wrapper(impl)
}
