package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.LabelingJobArn
import scala.jdk.CollectionConverters._
final case class CreateLabelingJobResponse(labelingJobArn: LabelingJobArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateLabelingJobResponse = {
    import CreateLabelingJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateLabelingJobResponse
      .builder()
      .labelingJobArn(LabelingJobArn.unwrap(labelingJobArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateLabelingJobResponse.ReadOnly =
    zio.aws.sagemaker.model.CreateLabelingJobResponse.wrap(buildAwsValue())
}
object CreateLabelingJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateLabelingJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateLabelingJobResponse =
      zio.aws.sagemaker.model.CreateLabelingJobResponse(labelingJobArn)
    def labelingJobArn: LabelingJobArn
    def getLabelingJobArn: ZIO[Any, Nothing, LabelingJobArn] =
      ZIO.succeed(labelingJobArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateLabelingJobResponse
  ) extends zio.aws.sagemaker.model.CreateLabelingJobResponse.ReadOnly {
    override val labelingJobArn: LabelingJobArn =
      zio.aws.sagemaker.model.primitives.LabelingJobArn(impl.labelingJobArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateLabelingJobResponse
  ): zio.aws.sagemaker.model.CreateLabelingJobResponse.ReadOnly = new Wrapper(
    impl
  )
}
