package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CaptureOption(
    captureMode: zio.aws.sagemaker.model.CaptureMode
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CaptureOption = {
    import CaptureOption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CaptureOption
      .builder()
      .captureMode(captureMode.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CaptureOption.ReadOnly =
    zio.aws.sagemaker.model.CaptureOption.wrap(buildAwsValue())
}
object CaptureOption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CaptureOption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CaptureOption =
      zio.aws.sagemaker.model.CaptureOption(captureMode)
    def captureMode: zio.aws.sagemaker.model.CaptureMode
    def getCaptureMode: ZIO[Any, Nothing, zio.aws.sagemaker.model.CaptureMode] =
      ZIO.succeed(captureMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CaptureOption
  ) extends zio.aws.sagemaker.model.CaptureOption.ReadOnly {
    override val captureMode: zio.aws.sagemaker.model.CaptureMode =
      zio.aws.sagemaker.model.CaptureMode.wrap(impl.captureMode())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CaptureOption
  ): zio.aws.sagemaker.model.CaptureOption.ReadOnly = new Wrapper(impl)
}
