package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CanvasAppSettings(
    timeSeriesForecastingSettings: Optional[
      zio.aws.sagemaker.model.TimeSeriesForecastingSettings
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CanvasAppSettings = {
    import CanvasAppSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CanvasAppSettings
      .builder()
      .optionallyWith(
        timeSeriesForecastingSettings.map(value => value.buildAwsValue())
      )(_.timeSeriesForecastingSettings)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CanvasAppSettings.ReadOnly =
    zio.aws.sagemaker.model.CanvasAppSettings.wrap(buildAwsValue())
}
object CanvasAppSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CanvasAppSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CanvasAppSettings =
      zio.aws.sagemaker.model.CanvasAppSettings(
        timeSeriesForecastingSettings.map(value => value.asEditable)
      )
    def timeSeriesForecastingSettings: Optional[
      zio.aws.sagemaker.model.TimeSeriesForecastingSettings.ReadOnly
    ]
    def getTimeSeriesForecastingSettings: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.TimeSeriesForecastingSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "timeSeriesForecastingSettings",
      timeSeriesForecastingSettings
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CanvasAppSettings
  ) extends zio.aws.sagemaker.model.CanvasAppSettings.ReadOnly {
    override val timeSeriesForecastingSettings: Optional[
      zio.aws.sagemaker.model.TimeSeriesForecastingSettings.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.timeSeriesForecastingSettings())
      .map(value =>
        zio.aws.sagemaker.model.TimeSeriesForecastingSettings.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CanvasAppSettings
  ): zio.aws.sagemaker.model.CanvasAppSettings.ReadOnly = new Wrapper(impl)
}
