package zio.aws.sagemaker
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  SubnetId,
  ResponseMIMEType,
  FlowDefinitionTaskKeyword,
  ContentType,
  FeatureParameterKey,
  ImageDeleteProperty,
  AttributeName,
  CustomerMetadataValue,
  DeviceName,
  SecurityGroupId,
  ParameterValue,
  ConfigValue,
  TaskKeyword,
  Cidr,
  TrialComponentKey64,
  ProcessingEnvironmentValue,
  EnvironmentKey,
  CsvContentType,
  WorkforceSecurityGroupId,
  CustomerMetadataKey,
  ProcessingEnvironmentKey,
  Group,
  TrainingEnvironmentKey,
  TrainingEnvironmentValue,
  EnvironmentValue,
  WorkforceSubnetId,
  HyperParameterKey,
  TransformEnvironmentValue,
  ContainerArgument,
  NeoVpcSubnetId,
  NeoVpcSecurityGroupId,
  ContainerEntrypointString,
  CodeRepositoryNameOrUrl,
  String128,
  TransformEnvironmentKey,
  ModelPackageArn,
  InstanceGroupName,
  JsonContentType,
  StudioLifecycleConfigArn,
  ConfigKey,
  String256,
  StringParameterValue,
  TrialComponentKey256,
  HyperParameterValue,
  String40,
  TagKey,
  AssociationEntityArn
}
import zio.aws.sagemaker.model.primitives.MonitoringJobDefinitionName.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object Accept extends Subtype[String]
    type Accept = zio.aws.sagemaker.model.primitives.Accept.Type
    object AccountId extends Subtype[String]
    type AccountId = zio.aws.sagemaker.model.primitives.AccountId.Type
    object ActionArn extends Subtype[String]
    type ActionArn = zio.aws.sagemaker.model.primitives.ActionArn.Type
    object AlarmName extends Subtype[String]
    type AlarmName = zio.aws.sagemaker.model.primitives.AlarmName.Type
    object AlgorithmArn extends Subtype[String]
    type AlgorithmArn = zio.aws.sagemaker.model.primitives.AlgorithmArn.Type
    object AlgorithmImage extends Subtype[String]
    type AlgorithmImage = zio.aws.sagemaker.model.primitives.AlgorithmImage.Type
    object AppArn extends Subtype[String]
    type AppArn = zio.aws.sagemaker.model.primitives.AppArn.Type
    object AppImageConfigArn extends Subtype[String]
    type AppImageConfigArn =
      zio.aws.sagemaker.model.primitives.AppImageConfigArn.Type
    object AppImageConfigName extends Subtype[String]
    type AppImageConfigName =
      zio.aws.sagemaker.model.primitives.AppImageConfigName.Type
    object AppManaged extends Subtype[Boolean]
    type AppManaged = zio.aws.sagemaker.model.primitives.AppManaged.Type
    object AppName extends Subtype[String]
    type AppName = zio.aws.sagemaker.model.primitives.AppName.Type
    object ApprovalDescription extends Subtype[String]
    type ApprovalDescription =
      zio.aws.sagemaker.model.primitives.ApprovalDescription.Type
    object ArnOrName extends Subtype[String]
    type ArnOrName = zio.aws.sagemaker.model.primitives.ArnOrName.Type
    object ArtifactArn extends Subtype[String]
    type ArtifactArn = zio.aws.sagemaker.model.primitives.ArtifactArn.Type
    object ArtifactDigest extends Subtype[String]
    type ArtifactDigest = zio.aws.sagemaker.model.primitives.ArtifactDigest.Type
    object AssociationEntityArn extends Subtype[String]
    type AssociationEntityArn =
      zio.aws.sagemaker.model.primitives.AssociationEntityArn.Type
    object AthenaCatalog extends Subtype[String]
    type AthenaCatalog = zio.aws.sagemaker.model.primitives.AthenaCatalog.Type
    object AthenaDatabase extends Subtype[String]
    type AthenaDatabase = zio.aws.sagemaker.model.primitives.AthenaDatabase.Type
    object AthenaQueryString extends Subtype[String]
    type AthenaQueryString =
      zio.aws.sagemaker.model.primitives.AthenaQueryString.Type
    object AthenaWorkGroup extends Subtype[String]
    type AthenaWorkGroup =
      zio.aws.sagemaker.model.primitives.AthenaWorkGroup.Type
    object AttributeName extends Subtype[String]
    type AttributeName = zio.aws.sagemaker.model.primitives.AttributeName.Type
    object AutoGenerateEndpointName extends Subtype[Boolean]
    type AutoGenerateEndpointName =
      zio.aws.sagemaker.model.primitives.AutoGenerateEndpointName.Type
    object AutoMLFailureReason extends Subtype[String]
    type AutoMLFailureReason =
      zio.aws.sagemaker.model.primitives.AutoMLFailureReason.Type
    object AutoMLJobArn extends Subtype[String]
    type AutoMLJobArn = zio.aws.sagemaker.model.primitives.AutoMLJobArn.Type
    object AutoMLJobName extends Subtype[String]
    type AutoMLJobName = zio.aws.sagemaker.model.primitives.AutoMLJobName.Type
    object AutoMLMaxResults extends Subtype[Int]
    type AutoMLMaxResults =
      zio.aws.sagemaker.model.primitives.AutoMLMaxResults.Type
    object AutoMLNameContains extends Subtype[String]
    type AutoMLNameContains =
      zio.aws.sagemaker.model.primitives.AutoMLNameContains.Type
    object BillableTimeInSeconds extends Subtype[Int]
    type BillableTimeInSeconds =
      zio.aws.sagemaker.model.primitives.BillableTimeInSeconds.Type
    object BlockedReason extends Subtype[String]
    type BlockedReason = zio.aws.sagemaker.model.primitives.BlockedReason.Type
    object Branch extends Subtype[String]
    type Branch = zio.aws.sagemaker.model.primitives.Branch.Type
    object BucketName extends Subtype[String]
    type BucketName = zio.aws.sagemaker.model.primitives.BucketName.Type
    object CallbackToken extends Subtype[String]
    type CallbackToken = zio.aws.sagemaker.model.primitives.CallbackToken.Type
    object CandidateDefinitionNotebookLocation extends Subtype[String]
    type CandidateDefinitionNotebookLocation =
      zio.aws.sagemaker.model.primitives.CandidateDefinitionNotebookLocation.Type
    object CandidateName extends Subtype[String]
    type CandidateName = zio.aws.sagemaker.model.primitives.CandidateName.Type
    object CandidateStepArn extends Subtype[String]
    type CandidateStepArn =
      zio.aws.sagemaker.model.primitives.CandidateStepArn.Type
    object CandidateStepName extends Subtype[String]
    type CandidateStepName =
      zio.aws.sagemaker.model.primitives.CandidateStepName.Type
    object CapacitySizeValue extends Subtype[Int]
    type CapacitySizeValue =
      zio.aws.sagemaker.model.primitives.CapacitySizeValue.Type
    object Catalog extends Subtype[String]
    type Catalog = zio.aws.sagemaker.model.primitives.Catalog.Type
    object Cents extends Subtype[Int]
    type Cents = zio.aws.sagemaker.model.primitives.Cents.Type
    object CertifyForMarketplace extends Subtype[Boolean]
    type CertifyForMarketplace =
      zio.aws.sagemaker.model.primitives.CertifyForMarketplace.Type
    object ChannelName extends Subtype[String]
    type ChannelName = zio.aws.sagemaker.model.primitives.ChannelName.Type
    object Cidr extends Subtype[String]
    type Cidr = zio.aws.sagemaker.model.primitives.Cidr.Type
    object ClientId extends Subtype[String]
    type ClientId = zio.aws.sagemaker.model.primitives.ClientId.Type
    object ClientSecret extends Subtype[String]
    type ClientSecret = zio.aws.sagemaker.model.primitives.ClientSecret.Type
    object ClientToken extends Subtype[String]
    type ClientToken = zio.aws.sagemaker.model.primitives.ClientToken.Type
    object CodeRepositoryArn extends Subtype[String]
    type CodeRepositoryArn =
      zio.aws.sagemaker.model.primitives.CodeRepositoryArn.Type
    object CodeRepositoryContains extends Subtype[String]
    type CodeRepositoryContains =
      zio.aws.sagemaker.model.primitives.CodeRepositoryContains.Type
    object CodeRepositoryNameContains extends Subtype[String]
    type CodeRepositoryNameContains =
      zio.aws.sagemaker.model.primitives.CodeRepositoryNameContains.Type
    object CodeRepositoryNameOrUrl extends Subtype[String]
    type CodeRepositoryNameOrUrl =
      zio.aws.sagemaker.model.primitives.CodeRepositoryNameOrUrl.Type
    object CognitoUserGroup extends Subtype[String]
    type CognitoUserGroup =
      zio.aws.sagemaker.model.primitives.CognitoUserGroup.Type
    object CognitoUserPool extends Subtype[String]
    type CognitoUserPool =
      zio.aws.sagemaker.model.primitives.CognitoUserPool.Type
    object CollectionName extends Subtype[String]
    type CollectionName = zio.aws.sagemaker.model.primitives.CollectionName.Type
    object CompilationJobArn extends Subtype[String]
    type CompilationJobArn =
      zio.aws.sagemaker.model.primitives.CompilationJobArn.Type
    object CompilerOptions extends Subtype[String]
    type CompilerOptions =
      zio.aws.sagemaker.model.primitives.CompilerOptions.Type
    object ConfigKey extends Subtype[String]
    type ConfigKey = zio.aws.sagemaker.model.primitives.ConfigKey.Type
    object ConfigValue extends Subtype[String]
    type ConfigValue = zio.aws.sagemaker.model.primitives.ConfigValue.Type
    object ContainerArgument extends Subtype[String]
    type ContainerArgument =
      zio.aws.sagemaker.model.primitives.ContainerArgument.Type
    object ContainerEntrypointString extends Subtype[String]
    type ContainerEntrypointString =
      zio.aws.sagemaker.model.primitives.ContainerEntrypointString.Type
    object ContainerHostname extends Subtype[String]
    type ContainerHostname =
      zio.aws.sagemaker.model.primitives.ContainerHostname.Type
    object ContainerImage extends Subtype[String]
    type ContainerImage = zio.aws.sagemaker.model.primitives.ContainerImage.Type
    object ContentDigest extends Subtype[String]
    type ContentDigest = zio.aws.sagemaker.model.primitives.ContentDigest.Type
    object ContentType extends Subtype[String]
    type ContentType = zio.aws.sagemaker.model.primitives.ContentType.Type
    object ContextArn extends Subtype[String]
    type ContextArn = zio.aws.sagemaker.model.primitives.ContextArn.Type
    object CreationTime extends Subtype[Instant]
    type CreationTime = zio.aws.sagemaker.model.primitives.CreationTime.Type
    object CsvContentType extends Subtype[String]
    type CsvContentType = zio.aws.sagemaker.model.primitives.CsvContentType.Type
    object CustomerMetadataKey extends Subtype[String]
    type CustomerMetadataKey =
      zio.aws.sagemaker.model.primitives.CustomerMetadataKey.Type
    object CustomerMetadataValue extends Subtype[String]
    type CustomerMetadataValue =
      zio.aws.sagemaker.model.primitives.CustomerMetadataValue.Type
    object DataExplorationNotebookLocation extends Subtype[String]
    type DataExplorationNotebookLocation =
      zio.aws.sagemaker.model.primitives.DataExplorationNotebookLocation.Type
    object DataInputConfig extends Subtype[String]
    type DataInputConfig =
      zio.aws.sagemaker.model.primitives.DataInputConfig.Type
    object Database extends Subtype[String]
    type Database = zio.aws.sagemaker.model.primitives.Database.Type
    object DefaultGid extends Subtype[Int]
    type DefaultGid = zio.aws.sagemaker.model.primitives.DefaultGid.Type
    object DefaultUid extends Subtype[Int]
    type DefaultUid = zio.aws.sagemaker.model.primitives.DefaultUid.Type
    object DeploymentStageMaxResults extends Subtype[Int]
    type DeploymentStageMaxResults =
      zio.aws.sagemaker.model.primitives.DeploymentStageMaxResults.Type
    object Description extends Subtype[String]
    type Description = zio.aws.sagemaker.model.primitives.Description.Type
    object DestinationS3Uri extends Subtype[String]
    type DestinationS3Uri =
      zio.aws.sagemaker.model.primitives.DestinationS3Uri.Type
    object DeviceArn extends Subtype[String]
    type DeviceArn = zio.aws.sagemaker.model.primitives.DeviceArn.Type
    object DeviceDescription extends Subtype[String]
    type DeviceDescription =
      zio.aws.sagemaker.model.primitives.DeviceDescription.Type
    object DeviceFleetArn extends Subtype[String]
    type DeviceFleetArn = zio.aws.sagemaker.model.primitives.DeviceFleetArn.Type
    object DeviceFleetDescription extends Subtype[String]
    type DeviceFleetDescription =
      zio.aws.sagemaker.model.primitives.DeviceFleetDescription.Type
    object DeviceName extends Subtype[String]
    type DeviceName = zio.aws.sagemaker.model.primitives.DeviceName.Type
    object DirectoryPath extends Subtype[String]
    type DirectoryPath = zio.aws.sagemaker.model.primitives.DirectoryPath.Type
    object DisableProfiler extends Subtype[Boolean]
    type DisableProfiler =
      zio.aws.sagemaker.model.primitives.DisableProfiler.Type
    object DisassociateAdditionalCodeRepositories extends Subtype[Boolean]
    type DisassociateAdditionalCodeRepositories =
      zio.aws.sagemaker.model.primitives.DisassociateAdditionalCodeRepositories.Type
    object DisassociateDefaultCodeRepository extends Subtype[Boolean]
    type DisassociateDefaultCodeRepository =
      zio.aws.sagemaker.model.primitives.DisassociateDefaultCodeRepository.Type
    object DisassociateNotebookInstanceAcceleratorTypes extends Subtype[Boolean]
    type DisassociateNotebookInstanceAcceleratorTypes =
      zio.aws.sagemaker.model.primitives.DisassociateNotebookInstanceAcceleratorTypes.Type
    object DisassociateNotebookInstanceLifecycleConfig extends Subtype[Boolean]
    type DisassociateNotebookInstanceLifecycleConfig =
      zio.aws.sagemaker.model.primitives.DisassociateNotebookInstanceLifecycleConfig.Type
    object Dollars extends Subtype[Int]
    type Dollars = zio.aws.sagemaker.model.primitives.Dollars.Type
    object DomainArn extends Subtype[String]
    type DomainArn = zio.aws.sagemaker.model.primitives.DomainArn.Type
    object DomainId extends Subtype[String]
    type DomainId = zio.aws.sagemaker.model.primitives.DomainId.Type
    object DomainName extends Subtype[String]
    type DomainName = zio.aws.sagemaker.model.primitives.DomainName.Type
    object DoubleParameterValue extends Subtype[Double]
    type DoubleParameterValue =
      zio.aws.sagemaker.model.primitives.DoubleParameterValue.Type
    object EdgeDeploymentPlanArn extends Subtype[String]
    type EdgeDeploymentPlanArn =
      zio.aws.sagemaker.model.primitives.EdgeDeploymentPlanArn.Type
    object EdgePackagingJobArn extends Subtype[String]
    type EdgePackagingJobArn =
      zio.aws.sagemaker.model.primitives.EdgePackagingJobArn.Type
    object EdgePresetDeploymentArtifact extends Subtype[String]
    type EdgePresetDeploymentArtifact =
      zio.aws.sagemaker.model.primitives.EdgePresetDeploymentArtifact.Type
    object EdgeVersion extends Subtype[String]
    type EdgeVersion = zio.aws.sagemaker.model.primitives.EdgeVersion.Type
    object EfsUid extends Subtype[String]
    type EfsUid = zio.aws.sagemaker.model.primitives.EfsUid.Type
    object EnableCapture extends Subtype[Boolean]
    type EnableCapture = zio.aws.sagemaker.model.primitives.EnableCapture.Type
    object EnableIotRoleAlias extends Subtype[Boolean]
    type EnableIotRoleAlias =
      zio.aws.sagemaker.model.primitives.EnableIotRoleAlias.Type
    object EndpointArn extends Subtype[String]
    type EndpointArn = zio.aws.sagemaker.model.primitives.EndpointArn.Type
    object EndpointConfigArn extends Subtype[String]
    type EndpointConfigArn =
      zio.aws.sagemaker.model.primitives.EndpointConfigArn.Type
    object EndpointConfigName extends Subtype[String]
    type EndpointConfigName =
      zio.aws.sagemaker.model.primitives.EndpointConfigName.Type
    object EndpointConfigNameContains extends Subtype[String]
    type EndpointConfigNameContains =
      zio.aws.sagemaker.model.primitives.EndpointConfigNameContains.Type
    object EndpointName extends Subtype[String]
    type EndpointName = zio.aws.sagemaker.model.primitives.EndpointName.Type
    object EndpointNameContains extends Subtype[String]
    type EndpointNameContains =
      zio.aws.sagemaker.model.primitives.EndpointNameContains.Type
    object EntityDescription extends Subtype[String]
    type EntityDescription =
      zio.aws.sagemaker.model.primitives.EntityDescription.Type
    object EntityName extends Subtype[String]
    type EntityName = zio.aws.sagemaker.model.primitives.EntityName.Type
    object EnvironmentKey extends Subtype[String]
    type EnvironmentKey = zio.aws.sagemaker.model.primitives.EnvironmentKey.Type
    object EnvironmentValue extends Subtype[String]
    type EnvironmentValue =
      zio.aws.sagemaker.model.primitives.EnvironmentValue.Type
    object ExitMessage extends Subtype[String]
    type ExitMessage = zio.aws.sagemaker.model.primitives.ExitMessage.Type
    object ExperimentArn extends Subtype[String]
    type ExperimentArn = zio.aws.sagemaker.model.primitives.ExperimentArn.Type
    object ExperimentDescription extends Subtype[String]
    type ExperimentDescription =
      zio.aws.sagemaker.model.primitives.ExperimentDescription.Type
    object ExperimentEntityName extends Subtype[String]
    type ExperimentEntityName =
      zio.aws.sagemaker.model.primitives.ExperimentEntityName.Type
    object ExperimentEntityNameOrArn extends Subtype[String]
    type ExperimentEntityNameOrArn =
      zio.aws.sagemaker.model.primitives.ExperimentEntityNameOrArn.Type
    object ExperimentSourceArn extends Subtype[String]
    type ExperimentSourceArn =
      zio.aws.sagemaker.model.primitives.ExperimentSourceArn.Type
    object ExpiresInSeconds extends Subtype[Int]
    type ExpiresInSeconds =
      zio.aws.sagemaker.model.primitives.ExpiresInSeconds.Type
    object ExplainabilityLocation extends Subtype[String]
    type ExplainabilityLocation =
      zio.aws.sagemaker.model.primitives.ExplainabilityLocation.Type
    object FailureReason extends Subtype[String]
    type FailureReason = zio.aws.sagemaker.model.primitives.FailureReason.Type
    object FeatureDescription extends Subtype[String]
    type FeatureDescription =
      zio.aws.sagemaker.model.primitives.FeatureDescription.Type
    object FeatureGroupArn extends Subtype[String]
    type FeatureGroupArn =
      zio.aws.sagemaker.model.primitives.FeatureGroupArn.Type
    object FeatureGroupMaxResults extends Subtype[Int]
    type FeatureGroupMaxResults =
      zio.aws.sagemaker.model.primitives.FeatureGroupMaxResults.Type
    object FeatureGroupName extends Subtype[String]
    type FeatureGroupName =
      zio.aws.sagemaker.model.primitives.FeatureGroupName.Type
    object FeatureGroupNameContains extends Subtype[String]
    type FeatureGroupNameContains =
      zio.aws.sagemaker.model.primitives.FeatureGroupNameContains.Type
    object FeatureName extends Subtype[String]
    type FeatureName = zio.aws.sagemaker.model.primitives.FeatureName.Type
    object FeatureParameterKey extends Subtype[String]
    type FeatureParameterKey =
      zio.aws.sagemaker.model.primitives.FeatureParameterKey.Type
    object FeatureParameterValue extends Subtype[String]
    type FeatureParameterValue =
      zio.aws.sagemaker.model.primitives.FeatureParameterValue.Type
    object FileSystemId extends Subtype[String]
    type FileSystemId = zio.aws.sagemaker.model.primitives.FileSystemId.Type
    object FilterValue extends Subtype[String]
    type FilterValue = zio.aws.sagemaker.model.primitives.FilterValue.Type
    object FlowDefinitionArn extends Subtype[String]
    type FlowDefinitionArn =
      zio.aws.sagemaker.model.primitives.FlowDefinitionArn.Type
    object FlowDefinitionName extends Subtype[String]
    type FlowDefinitionName =
      zio.aws.sagemaker.model.primitives.FlowDefinitionName.Type
    object FlowDefinitionTaskAvailabilityLifetimeInSeconds extends Subtype[Int]
    type FlowDefinitionTaskAvailabilityLifetimeInSeconds =
      zio.aws.sagemaker.model.primitives.FlowDefinitionTaskAvailabilityLifetimeInSeconds.Type
    object FlowDefinitionTaskCount extends Subtype[Int]
    type FlowDefinitionTaskCount =
      zio.aws.sagemaker.model.primitives.FlowDefinitionTaskCount.Type
    object FlowDefinitionTaskDescription extends Subtype[String]
    type FlowDefinitionTaskDescription =
      zio.aws.sagemaker.model.primitives.FlowDefinitionTaskDescription.Type
    object FlowDefinitionTaskKeyword extends Subtype[String]
    type FlowDefinitionTaskKeyword =
      zio.aws.sagemaker.model.primitives.FlowDefinitionTaskKeyword.Type
    object FlowDefinitionTaskTimeLimitInSeconds extends Subtype[Int]
    type FlowDefinitionTaskTimeLimitInSeconds =
      zio.aws.sagemaker.model.primitives.FlowDefinitionTaskTimeLimitInSeconds.Type
    object FlowDefinitionTaskTitle extends Subtype[String]
    type FlowDefinitionTaskTitle =
      zio.aws.sagemaker.model.primitives.FlowDefinitionTaskTitle.Type
    object FrameworkVersion extends Subtype[String]
    type FrameworkVersion =
      zio.aws.sagemaker.model.primitives.FrameworkVersion.Type
    object GenerateCandidateDefinitionsOnly extends Subtype[Boolean]
    type GenerateCandidateDefinitionsOnly =
      zio.aws.sagemaker.model.primitives.GenerateCandidateDefinitionsOnly.Type
    object GitConfigUrl extends Subtype[String]
    type GitConfigUrl = zio.aws.sagemaker.model.primitives.GitConfigUrl.Type
    object Group extends Subtype[String]
    type Group = zio.aws.sagemaker.model.primitives.Group.Type
    object HumanLoopActivationConditions extends Subtype[String]
    type HumanLoopActivationConditions =
      zio.aws.sagemaker.model.primitives.HumanLoopActivationConditions.Type
    object HumanTaskUiArn extends Subtype[String]
    type HumanTaskUiArn = zio.aws.sagemaker.model.primitives.HumanTaskUiArn.Type
    object HumanTaskUiName extends Subtype[String]
    type HumanTaskUiName =
      zio.aws.sagemaker.model.primitives.HumanTaskUiName.Type
    object HyperParameterKey extends Subtype[String]
    type HyperParameterKey =
      zio.aws.sagemaker.model.primitives.HyperParameterKey.Type
    object HyperParameterTrainingJobDefinitionName extends Subtype[String]
    type HyperParameterTrainingJobDefinitionName =
      zio.aws.sagemaker.model.primitives.HyperParameterTrainingJobDefinitionName.Type
    object HyperParameterTuningJobArn extends Subtype[String]
    type HyperParameterTuningJobArn =
      zio.aws.sagemaker.model.primitives.HyperParameterTuningJobArn.Type
    object HyperParameterTuningJobName extends Subtype[String]
    type HyperParameterTuningJobName =
      zio.aws.sagemaker.model.primitives.HyperParameterTuningJobName.Type
    object HyperParameterValue extends Subtype[String]
    type HyperParameterValue =
      zio.aws.sagemaker.model.primitives.HyperParameterValue.Type
    object HyperbandStrategyMaxResource extends Subtype[Int]
    type HyperbandStrategyMaxResource =
      zio.aws.sagemaker.model.primitives.HyperbandStrategyMaxResource.Type
    object HyperbandStrategyMinResource extends Subtype[Int]
    type HyperbandStrategyMinResource =
      zio.aws.sagemaker.model.primitives.HyperbandStrategyMinResource.Type
    object IdempotencyToken extends Subtype[String]
    type IdempotencyToken =
      zio.aws.sagemaker.model.primitives.IdempotencyToken.Type
    object ImageArn extends Subtype[String]
    type ImageArn = zio.aws.sagemaker.model.primitives.ImageArn.Type
    object ImageBaseImage extends Subtype[String]
    type ImageBaseImage = zio.aws.sagemaker.model.primitives.ImageBaseImage.Type
    object ImageContainerImage extends Subtype[String]
    type ImageContainerImage =
      zio.aws.sagemaker.model.primitives.ImageContainerImage.Type
    object ImageDeleteProperty extends Subtype[String]
    type ImageDeleteProperty =
      zio.aws.sagemaker.model.primitives.ImageDeleteProperty.Type
    object ImageDescription extends Subtype[String]
    type ImageDescription =
      zio.aws.sagemaker.model.primitives.ImageDescription.Type
    object ImageDigest extends Subtype[String]
    type ImageDigest = zio.aws.sagemaker.model.primitives.ImageDigest.Type
    object ImageDisplayName extends Subtype[String]
    type ImageDisplayName =
      zio.aws.sagemaker.model.primitives.ImageDisplayName.Type
    object ImageName extends Subtype[String]
    type ImageName = zio.aws.sagemaker.model.primitives.ImageName.Type
    object ImageNameContains extends Subtype[String]
    type ImageNameContains =
      zio.aws.sagemaker.model.primitives.ImageNameContains.Type
    object ImageUri extends Subtype[String]
    type ImageUri = zio.aws.sagemaker.model.primitives.ImageUri.Type
    object ImageVersionArn extends Subtype[String]
    type ImageVersionArn =
      zio.aws.sagemaker.model.primitives.ImageVersionArn.Type
    object ImageVersionNumber extends Subtype[Int]
    type ImageVersionNumber =
      zio.aws.sagemaker.model.primitives.ImageVersionNumber.Type
    object InferenceImage extends Subtype[String]
    type InferenceImage = zio.aws.sagemaker.model.primitives.InferenceImage.Type
    object InferenceSpecificationName extends Subtype[String]
    type InferenceSpecificationName =
      zio.aws.sagemaker.model.primitives.InferenceSpecificationName.Type
    object InitialNumberOfUsers extends Subtype[Int]
    type InitialNumberOfUsers =
      zio.aws.sagemaker.model.primitives.InitialNumberOfUsers.Type
    object InitialTaskCount extends Subtype[Int]
    type InitialTaskCount =
      zio.aws.sagemaker.model.primitives.InitialTaskCount.Type
    object InstanceGroupName extends Subtype[String]
    type InstanceGroupName =
      zio.aws.sagemaker.model.primitives.InstanceGroupName.Type
    type Integer = Int
    type IntegerValue = Int
    object InvocationsMaxRetries extends Subtype[Int]
    type InvocationsMaxRetries =
      zio.aws.sagemaker.model.primitives.InvocationsMaxRetries.Type
    object InvocationsTimeoutInSeconds extends Subtype[Int]
    type InvocationsTimeoutInSeconds =
      zio.aws.sagemaker.model.primitives.InvocationsTimeoutInSeconds.Type
    object IotRoleAlias extends Subtype[String]
    type IotRoleAlias = zio.aws.sagemaker.model.primitives.IotRoleAlias.Type
    object JobDurationInSeconds extends Subtype[Int]
    type JobDurationInSeconds =
      zio.aws.sagemaker.model.primitives.JobDurationInSeconds.Type
    object JobReferenceCode extends Subtype[String]
    type JobReferenceCode =
      zio.aws.sagemaker.model.primitives.JobReferenceCode.Type
    object JobReferenceCodeContains extends Subtype[String]
    type JobReferenceCodeContains =
      zio.aws.sagemaker.model.primitives.JobReferenceCodeContains.Type
    object JsonContentType extends Subtype[String]
    type JsonContentType =
      zio.aws.sagemaker.model.primitives.JsonContentType.Type
    object JsonPath extends Subtype[String]
    type JsonPath = zio.aws.sagemaker.model.primitives.JsonPath.Type
    object KernelDisplayName extends Subtype[String]
    type KernelDisplayName =
      zio.aws.sagemaker.model.primitives.KernelDisplayName.Type
    object KernelName extends Subtype[String]
    type KernelName = zio.aws.sagemaker.model.primitives.KernelName.Type
    object Key extends Subtype[String]
    type Key = zio.aws.sagemaker.model.primitives.Key.Type
    object KmsKeyId extends Subtype[String]
    type KmsKeyId = zio.aws.sagemaker.model.primitives.KmsKeyId.Type
    object LabelAttributeName extends Subtype[String]
    type LabelAttributeName =
      zio.aws.sagemaker.model.primitives.LabelAttributeName.Type
    object LabelCounter extends Subtype[Int]
    type LabelCounter = zio.aws.sagemaker.model.primitives.LabelCounter.Type
    object LabelingJobAlgorithmSpecificationArn extends Subtype[String]
    type LabelingJobAlgorithmSpecificationArn =
      zio.aws.sagemaker.model.primitives.LabelingJobAlgorithmSpecificationArn.Type
    object LabelingJobArn extends Subtype[String]
    type LabelingJobArn = zio.aws.sagemaker.model.primitives.LabelingJobArn.Type
    object LabelingJobName extends Subtype[String]
    type LabelingJobName =
      zio.aws.sagemaker.model.primitives.LabelingJobName.Type
    object LambdaFunctionArn extends Subtype[String]
    type LambdaFunctionArn =
      zio.aws.sagemaker.model.primitives.LambdaFunctionArn.Type
    object LastModifiedTime extends Subtype[Instant]
    type LastModifiedTime =
      zio.aws.sagemaker.model.primitives.LastModifiedTime.Type
    object LineageGroupArn extends Subtype[String]
    type LineageGroupArn =
      zio.aws.sagemaker.model.primitives.LineageGroupArn.Type
    object LineageGroupNameOrArn extends Subtype[String]
    type LineageGroupNameOrArn =
      zio.aws.sagemaker.model.primitives.LineageGroupNameOrArn.Type
    object ListMaxResults extends Subtype[Int]
    type ListMaxResults = zio.aws.sagemaker.model.primitives.ListMaxResults.Type
    object ListTagsMaxResults extends Subtype[Int]
    type ListTagsMaxResults =
      zio.aws.sagemaker.model.primitives.ListTagsMaxResults.Type
    object MaxAutoMLJobRuntimeInSeconds extends Subtype[Int]
    type MaxAutoMLJobRuntimeInSeconds =
      zio.aws.sagemaker.model.primitives.MaxAutoMLJobRuntimeInSeconds.Type
    object MaxCandidates extends Subtype[Int]
    type MaxCandidates = zio.aws.sagemaker.model.primitives.MaxCandidates.Type
    object MaxConcurrentInvocationsPerInstance extends Subtype[Int]
    type MaxConcurrentInvocationsPerInstance =
      zio.aws.sagemaker.model.primitives.MaxConcurrentInvocationsPerInstance.Type
    object MaxConcurrentTaskCount extends Subtype[Int]
    type MaxConcurrentTaskCount =
      zio.aws.sagemaker.model.primitives.MaxConcurrentTaskCount.Type
    object MaxConcurrentTransforms extends Subtype[Int]
    type MaxConcurrentTransforms =
      zio.aws.sagemaker.model.primitives.MaxConcurrentTransforms.Type
    object MaxHumanLabeledObjectCount extends Subtype[Int]
    type MaxHumanLabeledObjectCount =
      zio.aws.sagemaker.model.primitives.MaxHumanLabeledObjectCount.Type
    object MaxNumberOfTests extends Subtype[Int]
    type MaxNumberOfTests =
      zio.aws.sagemaker.model.primitives.MaxNumberOfTests.Type
    object MaxNumberOfTrainingJobs extends Subtype[Int]
    type MaxNumberOfTrainingJobs =
      zio.aws.sagemaker.model.primitives.MaxNumberOfTrainingJobs.Type
    object MaxParallelExecutionSteps extends Subtype[Int]
    type MaxParallelExecutionSteps =
      zio.aws.sagemaker.model.primitives.MaxParallelExecutionSteps.Type
    object MaxParallelOfTests extends Subtype[Int]
    type MaxParallelOfTests =
      zio.aws.sagemaker.model.primitives.MaxParallelOfTests.Type
    object MaxParallelTrainingJobs extends Subtype[Int]
    type MaxParallelTrainingJobs =
      zio.aws.sagemaker.model.primitives.MaxParallelTrainingJobs.Type
    object MaxPayloadInMB extends Subtype[Int]
    type MaxPayloadInMB = zio.aws.sagemaker.model.primitives.MaxPayloadInMB.Type
    object MaxPercentageOfInputDatasetLabeled extends Subtype[Int]
    type MaxPercentageOfInputDatasetLabeled =
      zio.aws.sagemaker.model.primitives.MaxPercentageOfInputDatasetLabeled.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.sagemaker.model.primitives.MaxResults.Type
    object MaxRuntimeInSeconds extends Subtype[Int]
    type MaxRuntimeInSeconds =
      zio.aws.sagemaker.model.primitives.MaxRuntimeInSeconds.Type
    object MaxRuntimePerTrainingJobInSeconds extends Subtype[Int]
    type MaxRuntimePerTrainingJobInSeconds =
      zio.aws.sagemaker.model.primitives.MaxRuntimePerTrainingJobInSeconds.Type
    object MaxWaitTimeInSeconds extends Subtype[Int]
    type MaxWaitTimeInSeconds =
      zio.aws.sagemaker.model.primitives.MaxWaitTimeInSeconds.Type
    object MaximumExecutionTimeoutInSeconds extends Subtype[Int]
    type MaximumExecutionTimeoutInSeconds =
      zio.aws.sagemaker.model.primitives.MaximumExecutionTimeoutInSeconds.Type
    object MaximumRetryAttempts extends Subtype[Int]
    type MaximumRetryAttempts =
      zio.aws.sagemaker.model.primitives.MaximumRetryAttempts.Type
    object MediaType extends Subtype[String]
    type MediaType = zio.aws.sagemaker.model.primitives.MediaType.Type
    object MetadataPropertyValue extends Subtype[String]
    type MetadataPropertyValue =
      zio.aws.sagemaker.model.primitives.MetadataPropertyValue.Type
    object MetricName extends Subtype[String]
    type MetricName = zio.aws.sagemaker.model.primitives.MetricName.Type
    object MetricRegex extends Subtype[String]
    type MetricRegex = zio.aws.sagemaker.model.primitives.MetricRegex.Type
    object MetricValue extends Subtype[Float]
    type MetricValue = zio.aws.sagemaker.model.primitives.MetricValue.Type
    object MinimumInstanceMetadataServiceVersion extends Subtype[String]
    type MinimumInstanceMetadataServiceVersion =
      zio.aws.sagemaker.model.primitives.MinimumInstanceMetadataServiceVersion.Type
    object ModelArn extends Subtype[String]
    type ModelArn = zio.aws.sagemaker.model.primitives.ModelArn.Type
    object ModelInsightsLocation extends Subtype[String]
    type ModelInsightsLocation =
      zio.aws.sagemaker.model.primitives.ModelInsightsLocation.Type
    object ModelName extends Subtype[String]
    type ModelName = zio.aws.sagemaker.model.primitives.ModelName.Type
    object ModelNameContains extends Subtype[String]
    type ModelNameContains =
      zio.aws.sagemaker.model.primitives.ModelNameContains.Type
    object ModelPackageArn extends Subtype[String]
    type ModelPackageArn =
      zio.aws.sagemaker.model.primitives.ModelPackageArn.Type
    object ModelPackageGroupArn extends Subtype[String]
    type ModelPackageGroupArn =
      zio.aws.sagemaker.model.primitives.ModelPackageGroupArn.Type
    object ModelPackageVersion extends Subtype[Int]
    type ModelPackageVersion =
      zio.aws.sagemaker.model.primitives.ModelPackageVersion.Type
    object MonitoringJobDefinitionArn extends Subtype[String]
    type MonitoringJobDefinitionArn =
      zio.aws.sagemaker.model.primitives.MonitoringJobDefinitionArn.Type
    object MonitoringJobDefinitionName extends Subtype[String]
    type MonitoringJobDefinitionName =
      zio.aws.sagemaker.model.primitives.MonitoringJobDefinitionName.Type
    object MonitoringMaxRuntimeInSeconds extends Subtype[Int]
    type MonitoringMaxRuntimeInSeconds =
      zio.aws.sagemaker.model.primitives.MonitoringMaxRuntimeInSeconds.Type
    object MonitoringS3Uri extends Subtype[String]
    type MonitoringS3Uri =
      zio.aws.sagemaker.model.primitives.MonitoringS3Uri.Type
    object MonitoringScheduleArn extends Subtype[String]
    type MonitoringScheduleArn =
      zio.aws.sagemaker.model.primitives.MonitoringScheduleArn.Type
    object MonitoringScheduleName extends Subtype[String]
    type MonitoringScheduleName =
      zio.aws.sagemaker.model.primitives.MonitoringScheduleName.Type
    object MonitoringTimeOffsetString extends Subtype[String]
    type MonitoringTimeOffsetString =
      zio.aws.sagemaker.model.primitives.MonitoringTimeOffsetString.Type
    object MountPath extends Subtype[String]
    type MountPath = zio.aws.sagemaker.model.primitives.MountPath.Type
    object NameContains extends Subtype[String]
    type NameContains = zio.aws.sagemaker.model.primitives.NameContains.Type
    object NeoVpcSecurityGroupId extends Subtype[String]
    type NeoVpcSecurityGroupId =
      zio.aws.sagemaker.model.primitives.NeoVpcSecurityGroupId.Type
    object NeoVpcSubnetId extends Subtype[String]
    type NeoVpcSubnetId = zio.aws.sagemaker.model.primitives.NeoVpcSubnetId.Type
    object NetworkInterfaceId extends Subtype[String]
    type NetworkInterfaceId =
      zio.aws.sagemaker.model.primitives.NetworkInterfaceId.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.sagemaker.model.primitives.NextToken.Type
    object NotebookInstanceArn extends Subtype[String]
    type NotebookInstanceArn =
      zio.aws.sagemaker.model.primitives.NotebookInstanceArn.Type
    object NotebookInstanceLifecycleConfigArn extends Subtype[String]
    type NotebookInstanceLifecycleConfigArn =
      zio.aws.sagemaker.model.primitives.NotebookInstanceLifecycleConfigArn.Type
    object NotebookInstanceLifecycleConfigContent extends Subtype[String]
    type NotebookInstanceLifecycleConfigContent =
      zio.aws.sagemaker.model.primitives.NotebookInstanceLifecycleConfigContent.Type
    object NotebookInstanceLifecycleConfigName extends Subtype[String]
    type NotebookInstanceLifecycleConfigName =
      zio.aws.sagemaker.model.primitives.NotebookInstanceLifecycleConfigName.Type
    object NotebookInstanceLifecycleConfigNameContains extends Subtype[String]
    type NotebookInstanceLifecycleConfigNameContains =
      zio.aws.sagemaker.model.primitives.NotebookInstanceLifecycleConfigNameContains.Type
    object NotebookInstanceName extends Subtype[String]
    type NotebookInstanceName =
      zio.aws.sagemaker.model.primitives.NotebookInstanceName.Type
    object NotebookInstanceNameContains extends Subtype[String]
    type NotebookInstanceNameContains =
      zio.aws.sagemaker.model.primitives.NotebookInstanceNameContains.Type
    object NotebookInstanceUrl extends Subtype[String]
    type NotebookInstanceUrl =
      zio.aws.sagemaker.model.primitives.NotebookInstanceUrl.Type
    object NotebookInstanceVolumeSizeInGB extends Subtype[Int]
    type NotebookInstanceVolumeSizeInGB =
      zio.aws.sagemaker.model.primitives.NotebookInstanceVolumeSizeInGB.Type
    object NotificationTopicArn extends Subtype[String]
    type NotificationTopicArn =
      zio.aws.sagemaker.model.primitives.NotificationTopicArn.Type
    object NumberOfHumanWorkersPerDataObject extends Subtype[Int]
    type NumberOfHumanWorkersPerDataObject =
      zio.aws.sagemaker.model.primitives.NumberOfHumanWorkersPerDataObject.Type
    object ObjectiveStatusCounter extends Subtype[Int]
    type ObjectiveStatusCounter =
      zio.aws.sagemaker.model.primitives.ObjectiveStatusCounter.Type
    object OidcEndpoint extends Subtype[String]
    type OidcEndpoint = zio.aws.sagemaker.model.primitives.OidcEndpoint.Type
    object OnlineStoreTotalSizeBytes extends Subtype[Long]
    type OnlineStoreTotalSizeBytes =
      zio.aws.sagemaker.model.primitives.OnlineStoreTotalSizeBytes.Type
    type OptionalDouble = Double
    type OptionalInteger = Int
    object OptionalVolumeSizeInGB extends Subtype[Int]
    type OptionalVolumeSizeInGB =
      zio.aws.sagemaker.model.primitives.OptionalVolumeSizeInGB.Type
    object PaginationToken extends Subtype[String]
    type PaginationToken =
      zio.aws.sagemaker.model.primitives.PaginationToken.Type
    object ParameterKey extends Subtype[String]
    type ParameterKey = zio.aws.sagemaker.model.primitives.ParameterKey.Type
    object ParameterName extends Subtype[String]
    type ParameterName = zio.aws.sagemaker.model.primitives.ParameterName.Type
    object ParameterValue extends Subtype[String]
    type ParameterValue = zio.aws.sagemaker.model.primitives.ParameterValue.Type
    object Percentage extends Subtype[Int]
    type Percentage = zio.aws.sagemaker.model.primitives.Percentage.Type
    object PipelineArn extends Subtype[String]
    type PipelineArn = zio.aws.sagemaker.model.primitives.PipelineArn.Type
    object PipelineDefinition extends Subtype[String]
    type PipelineDefinition =
      zio.aws.sagemaker.model.primitives.PipelineDefinition.Type
    object PipelineDescription extends Subtype[String]
    type PipelineDescription =
      zio.aws.sagemaker.model.primitives.PipelineDescription.Type
    object PipelineExecutionArn extends Subtype[String]
    type PipelineExecutionArn =
      zio.aws.sagemaker.model.primitives.PipelineExecutionArn.Type
    object PipelineExecutionDescription extends Subtype[String]
    type PipelineExecutionDescription =
      zio.aws.sagemaker.model.primitives.PipelineExecutionDescription.Type
    object PipelineExecutionFailureReason extends Subtype[String]
    type PipelineExecutionFailureReason =
      zio.aws.sagemaker.model.primitives.PipelineExecutionFailureReason.Type
    object PipelineExecutionName extends Subtype[String]
    type PipelineExecutionName =
      zio.aws.sagemaker.model.primitives.PipelineExecutionName.Type
    object PipelineName extends Subtype[String]
    type PipelineName = zio.aws.sagemaker.model.primitives.PipelineName.Type
    object PipelineParameterName extends Subtype[String]
    type PipelineParameterName =
      zio.aws.sagemaker.model.primitives.PipelineParameterName.Type
    object PlatformIdentifier extends Subtype[String]
    type PlatformIdentifier =
      zio.aws.sagemaker.model.primitives.PlatformIdentifier.Type
    object PolicyString extends Subtype[String]
    type PolicyString = zio.aws.sagemaker.model.primitives.PolicyString.Type
    object PresignedDomainUrl extends Subtype[String]
    type PresignedDomainUrl =
      zio.aws.sagemaker.model.primitives.PresignedDomainUrl.Type
    object ProbabilityThresholdAttribute extends Subtype[Double]
    type ProbabilityThresholdAttribute =
      zio.aws.sagemaker.model.primitives.ProbabilityThresholdAttribute.Type
    object ProcessingEnvironmentKey extends Subtype[String]
    type ProcessingEnvironmentKey =
      zio.aws.sagemaker.model.primitives.ProcessingEnvironmentKey.Type
    object ProcessingEnvironmentValue extends Subtype[String]
    type ProcessingEnvironmentValue =
      zio.aws.sagemaker.model.primitives.ProcessingEnvironmentValue.Type
    object ProcessingInstanceCount extends Subtype[Int]
    type ProcessingInstanceCount =
      zio.aws.sagemaker.model.primitives.ProcessingInstanceCount.Type
    object ProcessingJobArn extends Subtype[String]
    type ProcessingJobArn =
      zio.aws.sagemaker.model.primitives.ProcessingJobArn.Type
    object ProcessingJobName extends Subtype[String]
    type ProcessingJobName =
      zio.aws.sagemaker.model.primitives.ProcessingJobName.Type
    object ProcessingLocalPath extends Subtype[String]
    type ProcessingLocalPath =
      zio.aws.sagemaker.model.primitives.ProcessingLocalPath.Type
    object ProcessingMaxRuntimeInSeconds extends Subtype[Int]
    type ProcessingMaxRuntimeInSeconds =
      zio.aws.sagemaker.model.primitives.ProcessingMaxRuntimeInSeconds.Type
    object ProcessingVolumeSizeInGB extends Subtype[Int]
    type ProcessingVolumeSizeInGB =
      zio.aws.sagemaker.model.primitives.ProcessingVolumeSizeInGB.Type
    object ProductId extends Subtype[String]
    type ProductId = zio.aws.sagemaker.model.primitives.ProductId.Type
    object ProductionVariantContainerStartupHealthCheckTimeoutInSeconds
        extends Subtype[Int]
    type ProductionVariantContainerStartupHealthCheckTimeoutInSeconds =
      zio.aws.sagemaker.model.primitives.ProductionVariantContainerStartupHealthCheckTimeoutInSeconds.Type
    object ProductionVariantModelDataDownloadTimeoutInSeconds
        extends Subtype[Int]
    type ProductionVariantModelDataDownloadTimeoutInSeconds =
      zio.aws.sagemaker.model.primitives.ProductionVariantModelDataDownloadTimeoutInSeconds.Type
    object ProductionVariantVolumeSizeInGB extends Subtype[Int]
    type ProductionVariantVolumeSizeInGB =
      zio.aws.sagemaker.model.primitives.ProductionVariantVolumeSizeInGB.Type
    object ProfilingIntervalInMilliseconds extends Subtype[Long]
    type ProfilingIntervalInMilliseconds =
      zio.aws.sagemaker.model.primitives.ProfilingIntervalInMilliseconds.Type
    object ProjectArn extends Subtype[String]
    type ProjectArn = zio.aws.sagemaker.model.primitives.ProjectArn.Type
    object ProjectEntityName extends Subtype[String]
    type ProjectEntityName =
      zio.aws.sagemaker.model.primitives.ProjectEntityName.Type
    object ProjectId extends Subtype[String]
    type ProjectId = zio.aws.sagemaker.model.primitives.ProjectId.Type
    object PropertyNameHint extends Subtype[String]
    type PropertyNameHint =
      zio.aws.sagemaker.model.primitives.PropertyNameHint.Type
    object ProvisionedProductStatusMessage extends Subtype[String]
    type ProvisionedProductStatusMessage =
      zio.aws.sagemaker.model.primitives.ProvisionedProductStatusMessage.Type
    object ProvisioningParameterKey extends Subtype[String]
    type ProvisioningParameterKey =
      zio.aws.sagemaker.model.primitives.ProvisioningParameterKey.Type
    object ProvisioningParameterValue extends Subtype[String]
    type ProvisioningParameterValue =
      zio.aws.sagemaker.model.primitives.ProvisioningParameterValue.Type
    object QueryLineageMaxDepth extends Subtype[Int]
    type QueryLineageMaxDepth =
      zio.aws.sagemaker.model.primitives.QueryLineageMaxDepth.Type
    object QueryLineageMaxResults extends Subtype[Int]
    type QueryLineageMaxResults =
      zio.aws.sagemaker.model.primitives.QueryLineageMaxResults.Type
    object RecommendationJobArn extends Subtype[String]
    type RecommendationJobArn =
      zio.aws.sagemaker.model.primitives.RecommendationJobArn.Type
    object RecommendationJobDescription extends Subtype[String]
    type RecommendationJobDescription =
      zio.aws.sagemaker.model.primitives.RecommendationJobDescription.Type
    object RecommendationJobName extends Subtype[String]
    type RecommendationJobName =
      zio.aws.sagemaker.model.primitives.RecommendationJobName.Type
    object RedshiftClusterId extends Subtype[String]
    type RedshiftClusterId =
      zio.aws.sagemaker.model.primitives.RedshiftClusterId.Type
    object RedshiftDatabase extends Subtype[String]
    type RedshiftDatabase =
      zio.aws.sagemaker.model.primitives.RedshiftDatabase.Type
    object RedshiftQueryString extends Subtype[String]
    type RedshiftQueryString =
      zio.aws.sagemaker.model.primitives.RedshiftQueryString.Type
    object RedshiftUserName extends Subtype[String]
    type RedshiftUserName =
      zio.aws.sagemaker.model.primitives.RedshiftUserName.Type
    object RepositoryCredentialsProviderArn extends Subtype[String]
    type RepositoryCredentialsProviderArn =
      zio.aws.sagemaker.model.primitives.RepositoryCredentialsProviderArn.Type
    object ResourceArn extends Subtype[String]
    type ResourceArn = zio.aws.sagemaker.model.primitives.ResourceArn.Type
    object ResourceId extends Subtype[String]
    type ResourceId = zio.aws.sagemaker.model.primitives.ResourceId.Type
    object ResourcePolicyString extends Subtype[String]
    type ResourcePolicyString =
      zio.aws.sagemaker.model.primitives.ResourcePolicyString.Type
    object ResourcePropertyName extends Subtype[String]
    type ResourcePropertyName =
      zio.aws.sagemaker.model.primitives.ResourcePropertyName.Type
    object ResponseMIMEType extends Subtype[String]
    type ResponseMIMEType =
      zio.aws.sagemaker.model.primitives.ResponseMIMEType.Type
    object RoleArn extends Subtype[String]
    type RoleArn = zio.aws.sagemaker.model.primitives.RoleArn.Type
    object RuleConfigurationName extends Subtype[String]
    type RuleConfigurationName =
      zio.aws.sagemaker.model.primitives.RuleConfigurationName.Type
    object S3Uri extends Subtype[String]
    type S3Uri = zio.aws.sagemaker.model.primitives.S3Uri.Type
    object SamplingPercentage extends Subtype[Int]
    type SamplingPercentage =
      zio.aws.sagemaker.model.primitives.SamplingPercentage.Type
    object ScheduleExpression extends Subtype[String]
    type ScheduleExpression =
      zio.aws.sagemaker.model.primitives.ScheduleExpression.Type
    object SecretArn extends Subtype[String]
    type SecretArn = zio.aws.sagemaker.model.primitives.SecretArn.Type
    object SecurityGroupId extends Subtype[String]
    type SecurityGroupId =
      zio.aws.sagemaker.model.primitives.SecurityGroupId.Type
    object Seed extends Subtype[Long]
    type Seed = zio.aws.sagemaker.model.primitives.Seed.Type
    object ServerlessMaxConcurrency extends Subtype[Int]
    type ServerlessMaxConcurrency =
      zio.aws.sagemaker.model.primitives.ServerlessMaxConcurrency.Type
    object ServerlessMemorySizeInMB extends Subtype[Int]
    type ServerlessMemorySizeInMB =
      zio.aws.sagemaker.model.primitives.ServerlessMemorySizeInMB.Type
    object ServiceCatalogEntityId extends Subtype[String]
    type ServiceCatalogEntityId =
      zio.aws.sagemaker.model.primitives.ServiceCatalogEntityId.Type
    object SessionExpirationDurationInSeconds extends Subtype[Int]
    type SessionExpirationDurationInSeconds =
      zio.aws.sagemaker.model.primitives.SessionExpirationDurationInSeconds.Type
    object SingleSignOnUserIdentifier extends Subtype[String]
    type SingleSignOnUserIdentifier =
      zio.aws.sagemaker.model.primitives.SingleSignOnUserIdentifier.Type
    object SnsTopicArn extends Subtype[String]
    type SnsTopicArn = zio.aws.sagemaker.model.primitives.SnsTopicArn.Type
    object SourceType extends Subtype[String]
    type SourceType = zio.aws.sagemaker.model.primitives.SourceType.Type
    object SourceUri extends Subtype[String]
    type SourceUri = zio.aws.sagemaker.model.primitives.SourceUri.Type
    object SpawnRate extends Subtype[Int]
    type SpawnRate = zio.aws.sagemaker.model.primitives.SpawnRate.Type
    object StatusDetails extends Subtype[String]
    type StatusDetails = zio.aws.sagemaker.model.primitives.StatusDetails.Type
    object StatusMessage extends Subtype[String]
    type StatusMessage = zio.aws.sagemaker.model.primitives.StatusMessage.Type
    object StepDescription extends Subtype[String]
    type StepDescription =
      zio.aws.sagemaker.model.primitives.StepDescription.Type
    object StepDisplayName extends Subtype[String]
    type StepDisplayName =
      zio.aws.sagemaker.model.primitives.StepDisplayName.Type
    object StepName extends Subtype[String]
    type StepName = zio.aws.sagemaker.model.primitives.StepName.Type
    object String1024 extends Subtype[String]
    type String1024 = zio.aws.sagemaker.model.primitives.String1024.Type
    object String128 extends Subtype[String]
    type String128 = zio.aws.sagemaker.model.primitives.String128.Type
    object String200 extends Subtype[String]
    type String200 = zio.aws.sagemaker.model.primitives.String200.Type
    object String2048 extends Subtype[String]
    type String2048 = zio.aws.sagemaker.model.primitives.String2048.Type
    object String256 extends Subtype[String]
    type String256 = zio.aws.sagemaker.model.primitives.String256.Type
    object String3072 extends Subtype[String]
    type String3072 = zio.aws.sagemaker.model.primitives.String3072.Type
    object String40 extends Subtype[String]
    type String40 = zio.aws.sagemaker.model.primitives.String40.Type
    object String64 extends Subtype[String]
    type String64 = zio.aws.sagemaker.model.primitives.String64.Type
    object String8192 extends Subtype[String]
    type String8192 = zio.aws.sagemaker.model.primitives.String8192.Type
    object StringParameterValue extends Subtype[String]
    type StringParameterValue =
      zio.aws.sagemaker.model.primitives.StringParameterValue.Type
    object StudioLifecycleConfigArn extends Subtype[String]
    type StudioLifecycleConfigArn =
      zio.aws.sagemaker.model.primitives.StudioLifecycleConfigArn.Type
    object StudioLifecycleConfigContent extends Subtype[String]
    type StudioLifecycleConfigContent =
      zio.aws.sagemaker.model.primitives.StudioLifecycleConfigContent.Type
    object StudioLifecycleConfigName extends Subtype[String]
    type StudioLifecycleConfigName =
      zio.aws.sagemaker.model.primitives.StudioLifecycleConfigName.Type
    object SubnetId extends Subtype[String]
    type SubnetId = zio.aws.sagemaker.model.primitives.SubnetId.Type
    object Success extends Subtype[Boolean]
    type Success = zio.aws.sagemaker.model.primitives.Success.Type
    object TableName extends Subtype[String]
    type TableName = zio.aws.sagemaker.model.primitives.TableName.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.sagemaker.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.sagemaker.model.primitives.TagValue.Type
    object TargetAttributeName extends Subtype[String]
    type TargetAttributeName =
      zio.aws.sagemaker.model.primitives.TargetAttributeName.Type
    object TargetObjectiveMetricValue extends Subtype[Float]
    type TargetObjectiveMetricValue =
      zio.aws.sagemaker.model.primitives.TargetObjectiveMetricValue.Type
    object TaskAvailabilityLifetimeInSeconds extends Subtype[Int]
    type TaskAvailabilityLifetimeInSeconds =
      zio.aws.sagemaker.model.primitives.TaskAvailabilityLifetimeInSeconds.Type
    object TaskCount extends Subtype[Int]
    type TaskCount = zio.aws.sagemaker.model.primitives.TaskCount.Type
    object TaskDescription extends Subtype[String]
    type TaskDescription =
      zio.aws.sagemaker.model.primitives.TaskDescription.Type
    object TaskInput extends Subtype[String]
    type TaskInput = zio.aws.sagemaker.model.primitives.TaskInput.Type
    object TaskKeyword extends Subtype[String]
    type TaskKeyword = zio.aws.sagemaker.model.primitives.TaskKeyword.Type
    object TaskTimeLimitInSeconds extends Subtype[Int]
    type TaskTimeLimitInSeconds =
      zio.aws.sagemaker.model.primitives.TaskTimeLimitInSeconds.Type
    object TaskTitle extends Subtype[String]
    type TaskTitle = zio.aws.sagemaker.model.primitives.TaskTitle.Type
    object TemplateContent extends Subtype[String]
    type TemplateContent =
      zio.aws.sagemaker.model.primitives.TemplateContent.Type
    object TemplateContentSha256 extends Subtype[String]
    type TemplateContentSha256 =
      zio.aws.sagemaker.model.primitives.TemplateContentSha256.Type
    object TemplateUrl extends Subtype[String]
    type TemplateUrl = zio.aws.sagemaker.model.primitives.TemplateUrl.Type
    object TenthFractionsOfACent extends Subtype[Int]
    type TenthFractionsOfACent =
      zio.aws.sagemaker.model.primitives.TenthFractionsOfACent.Type
    object TerminationWaitInSeconds extends Subtype[Int]
    type TerminationWaitInSeconds =
      zio.aws.sagemaker.model.primitives.TerminationWaitInSeconds.Type
    object ThingName extends Subtype[String]
    type ThingName = zio.aws.sagemaker.model.primitives.ThingName.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.sagemaker.model.primitives.Timestamp.Type
    object TrafficDurationInSeconds extends Subtype[Int]
    type TrafficDurationInSeconds =
      zio.aws.sagemaker.model.primitives.TrafficDurationInSeconds.Type
    object TrainingEnvironmentKey extends Subtype[String]
    type TrainingEnvironmentKey =
      zio.aws.sagemaker.model.primitives.TrainingEnvironmentKey.Type
    object TrainingEnvironmentValue extends Subtype[String]
    type TrainingEnvironmentValue =
      zio.aws.sagemaker.model.primitives.TrainingEnvironmentValue.Type
    object TrainingInstanceCount extends Subtype[Int]
    type TrainingInstanceCount =
      zio.aws.sagemaker.model.primitives.TrainingInstanceCount.Type
    object TrainingJobArn extends Subtype[String]
    type TrainingJobArn = zio.aws.sagemaker.model.primitives.TrainingJobArn.Type
    object TrainingJobName extends Subtype[String]
    type TrainingJobName =
      zio.aws.sagemaker.model.primitives.TrainingJobName.Type
    object TrainingJobStatusCounter extends Subtype[Int]
    type TrainingJobStatusCounter =
      zio.aws.sagemaker.model.primitives.TrainingJobStatusCounter.Type
    object TrainingTimeInSeconds extends Subtype[Int]
    type TrainingTimeInSeconds =
      zio.aws.sagemaker.model.primitives.TrainingTimeInSeconds.Type
    object TransformEnvironmentKey extends Subtype[String]
    type TransformEnvironmentKey =
      zio.aws.sagemaker.model.primitives.TransformEnvironmentKey.Type
    object TransformEnvironmentValue extends Subtype[String]
    type TransformEnvironmentValue =
      zio.aws.sagemaker.model.primitives.TransformEnvironmentValue.Type
    object TransformInstanceCount extends Subtype[Int]
    type TransformInstanceCount =
      zio.aws.sagemaker.model.primitives.TransformInstanceCount.Type
    object TransformJobArn extends Subtype[String]
    type TransformJobArn =
      zio.aws.sagemaker.model.primitives.TransformJobArn.Type
    object TransformJobName extends Subtype[String]
    type TransformJobName =
      zio.aws.sagemaker.model.primitives.TransformJobName.Type
    object TrialArn extends Subtype[String]
    type TrialArn = zio.aws.sagemaker.model.primitives.TrialArn.Type
    object TrialComponentArn extends Subtype[String]
    type TrialComponentArn =
      zio.aws.sagemaker.model.primitives.TrialComponentArn.Type
    object TrialComponentArtifactValue extends Subtype[String]
    type TrialComponentArtifactValue =
      zio.aws.sagemaker.model.primitives.TrialComponentArtifactValue.Type
    object TrialComponentKey256 extends Subtype[String]
    type TrialComponentKey256 =
      zio.aws.sagemaker.model.primitives.TrialComponentKey256.Type
    object TrialComponentKey64 extends Subtype[String]
    type TrialComponentKey64 =
      zio.aws.sagemaker.model.primitives.TrialComponentKey64.Type
    object TrialComponentSourceArn extends Subtype[String]
    type TrialComponentSourceArn =
      zio.aws.sagemaker.model.primitives.TrialComponentSourceArn.Type
    object TrialComponentStatusMessage extends Subtype[String]
    type TrialComponentStatusMessage =
      zio.aws.sagemaker.model.primitives.TrialComponentStatusMessage.Type
    object TrialSourceArn extends Subtype[String]
    type TrialSourceArn = zio.aws.sagemaker.model.primitives.TrialSourceArn.Type
    object Url extends Subtype[String]
    type Url = zio.aws.sagemaker.model.primitives.Url.Type
    object UserProfileArn extends Subtype[String]
    type UserProfileArn = zio.aws.sagemaker.model.primitives.UserProfileArn.Type
    object UserProfileName extends Subtype[String]
    type UserProfileName =
      zio.aws.sagemaker.model.primitives.UserProfileName.Type
    object ValidationFraction extends Subtype[Float]
    type ValidationFraction =
      zio.aws.sagemaker.model.primitives.ValidationFraction.Type
    object VariantName extends Subtype[String]
    type VariantName = zio.aws.sagemaker.model.primitives.VariantName.Type
    object VariantStatusMessage extends Subtype[String]
    type VariantStatusMessage =
      zio.aws.sagemaker.model.primitives.VariantStatusMessage.Type
    object VariantWeight extends Subtype[Float]
    type VariantWeight = zio.aws.sagemaker.model.primitives.VariantWeight.Type
    object VersionId extends Subtype[String]
    type VersionId = zio.aws.sagemaker.model.primitives.VersionId.Type
    object VersionedArnOrName extends Subtype[String]
    type VersionedArnOrName =
      zio.aws.sagemaker.model.primitives.VersionedArnOrName.Type
    object VolumeSizeInGB extends Subtype[Int]
    type VolumeSizeInGB = zio.aws.sagemaker.model.primitives.VolumeSizeInGB.Type
    object VpcId extends Subtype[String]
    type VpcId = zio.aws.sagemaker.model.primitives.VpcId.Type
    object WaitIntervalInSeconds extends Subtype[Int]
    type WaitIntervalInSeconds =
      zio.aws.sagemaker.model.primitives.WaitIntervalInSeconds.Type
    object WorkforceArn extends Subtype[String]
    type WorkforceArn = zio.aws.sagemaker.model.primitives.WorkforceArn.Type
    object WorkforceFailureReason extends Subtype[String]
    type WorkforceFailureReason =
      zio.aws.sagemaker.model.primitives.WorkforceFailureReason.Type
    object WorkforceName extends Subtype[String]
    type WorkforceName = zio.aws.sagemaker.model.primitives.WorkforceName.Type
    object WorkforceSecurityGroupId extends Subtype[String]
    type WorkforceSecurityGroupId =
      zio.aws.sagemaker.model.primitives.WorkforceSecurityGroupId.Type
    object WorkforceSubnetId extends Subtype[String]
    type WorkforceSubnetId =
      zio.aws.sagemaker.model.primitives.WorkforceSubnetId.Type
    object WorkforceVpcEndpointId extends Subtype[String]
    type WorkforceVpcEndpointId =
      zio.aws.sagemaker.model.primitives.WorkforceVpcEndpointId.Type
    object WorkforceVpcId extends Subtype[String]
    type WorkforceVpcId = zio.aws.sagemaker.model.primitives.WorkforceVpcId.Type
    object WorkteamArn extends Subtype[String]
    type WorkteamArn = zio.aws.sagemaker.model.primitives.WorkteamArn.Type
    object WorkteamName extends Subtype[String]
    type WorkteamName = zio.aws.sagemaker.model.primitives.WorkteamName.Type
  }
  type ActionSummaries = List[zio.aws.sagemaker.model.ActionSummary]
  type AdditionalCodeRepositoryNamesOrUrls = List[CodeRepositoryNameOrUrl]
  type AdditionalInferenceSpecifications =
    List[zio.aws.sagemaker.model.AdditionalInferenceSpecificationDefinition]
  type AgentVersions = List[zio.aws.sagemaker.model.AgentVersion]
  type AlarmList = List[zio.aws.sagemaker.model.Alarm]
  type AlgorithmStatusItemList =
    List[zio.aws.sagemaker.model.AlgorithmStatusItem]
  type AlgorithmSummaryList = List[zio.aws.sagemaker.model.AlgorithmSummary]
  type AlgorithmValidationProfiles =
    List[zio.aws.sagemaker.model.AlgorithmValidationProfile]
  type AppImageConfigList = List[zio.aws.sagemaker.model.AppImageConfigDetails]
  type AppList = List[zio.aws.sagemaker.model.AppDetails]
  type ArtifactSourceTypes = List[zio.aws.sagemaker.model.ArtifactSourceType]
  type ArtifactSummaries = List[zio.aws.sagemaker.model.ArtifactSummary]
  type AssociationSummaries = List[zio.aws.sagemaker.model.AssociationSummary]
  type AttributeNames = List[AttributeName]
  type AutoMLCandidates = List[zio.aws.sagemaker.model.AutoMLCandidate]
  type AutoMLContainerDefinitions =
    List[zio.aws.sagemaker.model.AutoMLContainerDefinition]
  type AutoMLInputDataConfig = List[zio.aws.sagemaker.model.AutoMLChannel]
  type AutoMLJobSummaries = List[zio.aws.sagemaker.model.AutoMLJobSummary]
  type AutoMLPartialFailureReasons =
    List[zio.aws.sagemaker.model.AutoMLPartialFailureReason]
  type BatchDescribeModelPackageErrorMap =
    Map[ModelPackageArn, zio.aws.sagemaker.model.BatchDescribeModelPackageError]
  type CandidateSteps = List[zio.aws.sagemaker.model.AutoMLCandidateStep]
  type CaptureOptionList = List[zio.aws.sagemaker.model.CaptureOption]
  type CategoricalParameterRangeValues = List[String128]
  type CategoricalParameterRanges =
    List[zio.aws.sagemaker.model.CategoricalParameterRange]
  type CategoricalParameters =
    List[zio.aws.sagemaker.model.CategoricalParameter]
  type ChannelSpecifications =
    List[zio.aws.sagemaker.model.ChannelSpecification]
  type Cidrs = List[Cidr]
  type CodeRepositorySummaryList =
    List[zio.aws.sagemaker.model.CodeRepositorySummary]
  type CollectionConfigurations =
    List[zio.aws.sagemaker.model.CollectionConfiguration]
  type CollectionParameters = Map[ConfigKey, ConfigValue]
  type CompilationJobSummaries =
    List[zio.aws.sagemaker.model.CompilationJobSummary]
  type CompressionTypes = List[zio.aws.sagemaker.model.CompressionType]
  type ContainerArguments = List[ContainerArgument]
  type ContainerDefinitionList =
    List[zio.aws.sagemaker.model.ContainerDefinition]
  type ContainerEntrypoint = List[ContainerEntrypointString]
  type ContentClassifiers = List[zio.aws.sagemaker.model.ContentClassifier]
  type ContentTypes = List[ContentType]
  type ContextSummaries = List[zio.aws.sagemaker.model.ContextSummary]
  type ContinuousParameterRanges =
    List[zio.aws.sagemaker.model.ContinuousParameterRange]
  type CsvContentTypes = List[CsvContentType]
  type CustomImages = List[zio.aws.sagemaker.model.CustomImage]
  type CustomerMetadataKeyList = List[CustomerMetadataKey]
  type CustomerMetadataMap = Map[CustomerMetadataKey, CustomerMetadataValue]
  type DebugRuleConfigurations =
    List[zio.aws.sagemaker.model.DebugRuleConfiguration]
  type DebugRuleEvaluationStatuses =
    List[zio.aws.sagemaker.model.DebugRuleEvaluationStatus]
  type DeployedImages = List[zio.aws.sagemaker.model.DeployedImage]
  type DeploymentStageStatusSummaries =
    List[zio.aws.sagemaker.model.DeploymentStageStatusSummary]
  type DeploymentStages = List[zio.aws.sagemaker.model.DeploymentStage]
  type DesiredWeightAndCapacityList =
    List[zio.aws.sagemaker.model.DesiredWeightAndCapacity]
  type DeviceDeploymentSummaries =
    List[zio.aws.sagemaker.model.DeviceDeploymentSummary]
  type DeviceFleetSummaries = List[zio.aws.sagemaker.model.DeviceFleetSummary]
  type DeviceNames = List[DeviceName]
  type DeviceSummaries = List[zio.aws.sagemaker.model.DeviceSummary]
  type Devices = List[zio.aws.sagemaker.model.Device]
  type DomainList = List[zio.aws.sagemaker.model.DomainDetails]
  type DomainSecurityGroupIds = List[SecurityGroupId]
  type EdgeDeploymentModelConfigs =
    List[zio.aws.sagemaker.model.EdgeDeploymentModelConfig]
  type EdgeDeploymentPlanSummaries =
    List[zio.aws.sagemaker.model.EdgeDeploymentPlanSummary]
  type EdgeModelStats = List[zio.aws.sagemaker.model.EdgeModelStat]
  type EdgeModelSummaries = List[zio.aws.sagemaker.model.EdgeModelSummary]
  type EdgeModels = List[zio.aws.sagemaker.model.EdgeModel]
  type EdgePackagingJobSummaries =
    List[zio.aws.sagemaker.model.EdgePackagingJobSummary]
  type Edges = List[zio.aws.sagemaker.model.Edge]
  type EndpointConfigSummaryList =
    List[zio.aws.sagemaker.model.EndpointConfigSummary]
  type EndpointInputConfigurations =
    List[zio.aws.sagemaker.model.EndpointInputConfiguration]
  type EndpointSummaryList = List[zio.aws.sagemaker.model.EndpointSummary]
  type EnvironmentMap = Map[EnvironmentKey, EnvironmentValue]
  type EnvironmentParameters =
    List[zio.aws.sagemaker.model.EnvironmentParameter]
  type ExperimentSummaries = List[zio.aws.sagemaker.model.ExperimentSummary]
  type FeatureAdditions = List[zio.aws.sagemaker.model.FeatureDefinition]
  type FeatureDefinitions = List[zio.aws.sagemaker.model.FeatureDefinition]
  type FeatureGroupSummaries = List[zio.aws.sagemaker.model.FeatureGroupSummary]
  type FeatureParameterAdditions =
    List[zio.aws.sagemaker.model.FeatureParameter]
  type FeatureParameterRemovals = List[FeatureParameterKey]
  type FeatureParameters = List[zio.aws.sagemaker.model.FeatureParameter]
  type FilterList = List[zio.aws.sagemaker.model.Filter]
  type FinalMetricDataList = List[zio.aws.sagemaker.model.MetricData]
  type FlowDefinitionSummaries =
    List[zio.aws.sagemaker.model.FlowDefinitionSummary]
  type FlowDefinitionTaskKeywords = List[FlowDefinitionTaskKeyword]
  type Groups = List[Group]
  type HookParameters = Map[ConfigKey, ConfigValue]
  type HumanTaskUiSummaries = List[zio.aws.sagemaker.model.HumanTaskUiSummary]
  type HyperParameterSpecifications =
    List[zio.aws.sagemaker.model.HyperParameterSpecification]
  type HyperParameterTrainingJobDefinitions =
    List[zio.aws.sagemaker.model.HyperParameterTrainingJobDefinition]
  type HyperParameterTrainingJobSummaries =
    List[zio.aws.sagemaker.model.HyperParameterTrainingJobSummary]
  type HyperParameterTuningInstanceConfigs =
    List[zio.aws.sagemaker.model.HyperParameterTuningInstanceConfig]
  type HyperParameterTuningJobObjectives =
    List[zio.aws.sagemaker.model.HyperParameterTuningJobObjective]
  type HyperParameterTuningJobSummaries =
    List[zio.aws.sagemaker.model.HyperParameterTuningJobSummary]
  type HyperParameters = Map[HyperParameterKey, HyperParameterValue]
  type ImageDeletePropertyList = List[ImageDeleteProperty]
  type ImageVersions = List[zio.aws.sagemaker.model.ImageVersion]
  type Images = List[zio.aws.sagemaker.model.Image]
  type InferenceRecommendations =
    List[zio.aws.sagemaker.model.InferenceRecommendation]
  type InferenceRecommendationsJobs =
    List[zio.aws.sagemaker.model.InferenceRecommendationsJob]
  type InputDataConfig = List[zio.aws.sagemaker.model.Channel]
  type InputModes = List[zio.aws.sagemaker.model.TrainingInputMode]
  type InstanceGroupNames = List[InstanceGroupName]
  type InstanceGroups = List[zio.aws.sagemaker.model.InstanceGroup]
  type IntegerParameterRanges =
    List[zio.aws.sagemaker.model.IntegerParameterRange]
  type JsonContentTypes = List[JsonContentType]
  type KernelSpecs = List[zio.aws.sagemaker.model.KernelSpec]
  type LabelingJobForWorkteamSummaryList =
    List[zio.aws.sagemaker.model.LabelingJobForWorkteamSummary]
  type LabelingJobSummaryList = List[zio.aws.sagemaker.model.LabelingJobSummary]
  type LifecycleConfigArns = List[StudioLifecycleConfigArn]
  type LineageEntityParameters = Map[StringParameterValue, StringParameterValue]
  type LineageGroupSummaries = List[zio.aws.sagemaker.model.LineageGroupSummary]
  type ListLineageEntityParameterKey = List[StringParameterValue]
  type ListTrialComponentKey256 = List[TrialComponentKey256]
  type MemberDefinitions = List[zio.aws.sagemaker.model.MemberDefinition]
  type MetricDataList = List[zio.aws.sagemaker.model.MetricDatum]
  type MetricDefinitionList = List[zio.aws.sagemaker.model.MetricDefinition]
  type ModelLatencyThresholds =
    List[zio.aws.sagemaker.model.ModelLatencyThreshold]
  type ModelMetadataFilters = List[zio.aws.sagemaker.model.ModelMetadataFilter]
  type ModelMetadataSummaries =
    List[zio.aws.sagemaker.model.ModelMetadataSummary]
  type ModelPackageArnList = List[ModelPackageArn]
  type ModelPackageContainerDefinitionList =
    List[zio.aws.sagemaker.model.ModelPackageContainerDefinition]
  type ModelPackageGroupSummaryList =
    List[zio.aws.sagemaker.model.ModelPackageGroupSummary]
  type ModelPackageStatusItemList =
    List[zio.aws.sagemaker.model.ModelPackageStatusItem]
  type ModelPackageSummaries = Map[
    ModelPackageArn,
    zio.aws.sagemaker.model.BatchDescribeModelPackageSummary
  ]
  type ModelPackageSummaryList =
    List[zio.aws.sagemaker.model.ModelPackageSummary]
  type ModelPackageValidationProfiles =
    List[zio.aws.sagemaker.model.ModelPackageValidationProfile]
  type ModelSummaryList = List[zio.aws.sagemaker.model.ModelSummary]
  type MonitoringContainerArguments = List[ContainerArgument]
  type MonitoringEnvironmentMap =
    Map[ProcessingEnvironmentKey, ProcessingEnvironmentValue]
  type MonitoringExecutionSummaryList =
    List[zio.aws.sagemaker.model.MonitoringExecutionSummary]
  type MonitoringInputs = List[zio.aws.sagemaker.model.MonitoringInput]
  type MonitoringJobDefinitionSummaryList =
    List[zio.aws.sagemaker.model.MonitoringJobDefinitionSummary]
  type MonitoringOutputs = List[zio.aws.sagemaker.model.MonitoringOutput]
  type MonitoringScheduleList = List[zio.aws.sagemaker.model.MonitoringSchedule]
  type MonitoringScheduleSummaryList =
    List[zio.aws.sagemaker.model.MonitoringScheduleSummary]
  type NeoVpcSecurityGroupIds = List[NeoVpcSecurityGroupId]
  type NeoVpcSubnets = List[NeoVpcSubnetId]
  type NestedFiltersList = List[zio.aws.sagemaker.model.NestedFilters]
  type NotebookInstanceAcceleratorTypes =
    List[zio.aws.sagemaker.model.NotebookInstanceAcceleratorType]
  type NotebookInstanceLifecycleConfigList =
    List[zio.aws.sagemaker.model.NotebookInstanceLifecycleHook]
  type NotebookInstanceLifecycleConfigSummaryList =
    List[zio.aws.sagemaker.model.NotebookInstanceLifecycleConfigSummary]
  type NotebookInstanceSummaryList =
    List[zio.aws.sagemaker.model.NotebookInstanceSummary]
  type OutputParameterList = List[zio.aws.sagemaker.model.OutputParameter]
  type ParameterList = List[zio.aws.sagemaker.model.Parameter]
  type ParameterValues = List[ParameterValue]
  type ParentHyperParameterTuningJobs =
    List[zio.aws.sagemaker.model.ParentHyperParameterTuningJob]
  type Parents = List[zio.aws.sagemaker.model.Parent]
  type PendingProductionVariantSummaryList =
    List[zio.aws.sagemaker.model.PendingProductionVariantSummary]
  type Phases = List[zio.aws.sagemaker.model.Phase]
  type PipelineExecutionStepList =
    List[zio.aws.sagemaker.model.PipelineExecutionStep]
  type PipelineExecutionSummaryList =
    List[zio.aws.sagemaker.model.PipelineExecutionSummary]
  type PipelineSummaryList = List[zio.aws.sagemaker.model.PipelineSummary]
  type ProcessingEnvironmentMap =
    Map[ProcessingEnvironmentKey, ProcessingEnvironmentValue]
  type ProcessingInputs = List[zio.aws.sagemaker.model.ProcessingInput]
  type ProcessingJobSummaries =
    List[zio.aws.sagemaker.model.ProcessingJobSummary]
  type ProcessingOutputs = List[zio.aws.sagemaker.model.ProcessingOutput]
  type ProductListings = List[String]
  type ProductionVariantList = List[zio.aws.sagemaker.model.ProductionVariant]
  type ProductionVariantStatusList =
    List[zio.aws.sagemaker.model.ProductionVariantStatus]
  type ProductionVariantSummaryList =
    List[zio.aws.sagemaker.model.ProductionVariantSummary]
  type ProfilerRuleConfigurations =
    List[zio.aws.sagemaker.model.ProfilerRuleConfiguration]
  type ProfilerRuleEvaluationStatuses =
    List[zio.aws.sagemaker.model.ProfilerRuleEvaluationStatus]
  type ProfilingParameters = Map[ConfigKey, ConfigValue]
  type ProjectSummaryList = List[zio.aws.sagemaker.model.ProjectSummary]
  type PropertyNameSuggestionList =
    List[zio.aws.sagemaker.model.PropertyNameSuggestion]
  type ProvisioningParameters =
    List[zio.aws.sagemaker.model.ProvisioningParameter]
  type QueryLineageStartArns = List[AssociationEntityArn]
  type QueryLineageTypes = List[zio.aws.sagemaker.model.LineageType]
  type QueryProperties = Map[String256, String256]
  type QueryTypes = List[String40]
  type RealtimeInferenceInstanceTypes =
    List[zio.aws.sagemaker.model.ProductionVariantInstanceType]
  type RecommendationJobSupportedContentTypes = List[String]
  type RecommendationJobSupportedInstanceTypes = List[String]
  type RenderingErrorList = List[zio.aws.sagemaker.model.RenderingError]
  type ResponseMIMETypes = List[ResponseMIMEType]
  type RuleParameters = Map[ConfigKey, ConfigValue]
  type SearchExpressionList = List[zio.aws.sagemaker.model.SearchExpression]
  type SearchResultsList = List[zio.aws.sagemaker.model.SearchRecord]
  type SecondaryStatusTransitions =
    List[zio.aws.sagemaker.model.SecondaryStatusTransition]
  type SecurityGroupIds = List[SecurityGroupId]
  type SourceAlgorithmList = List[zio.aws.sagemaker.model.SourceAlgorithm]
  type StudioLifecycleConfigsList =
    List[zio.aws.sagemaker.model.StudioLifecycleConfigDetails]
  type Subnets = List[SubnetId]
  type SubscribedWorkteams = List[zio.aws.sagemaker.model.SubscribedWorkteam]
  type TagKeyList = List[TagKey]
  type TagList = List[zio.aws.sagemaker.model.Tag]
  type TaskKeywords = List[TaskKeyword]
  type TrainingEnvironmentMap =
    Map[TrainingEnvironmentKey, TrainingEnvironmentValue]
  type TrainingInstanceTypes =
    List[zio.aws.sagemaker.model.TrainingInstanceType]
  type TrainingJobSummaries = List[zio.aws.sagemaker.model.TrainingJobSummary]
  type TransformEnvironmentMap =
    Map[TransformEnvironmentKey, TransformEnvironmentValue]
  type TransformInstanceTypes =
    List[zio.aws.sagemaker.model.TransformInstanceType]
  type TransformJobSummaries = List[zio.aws.sagemaker.model.TransformJobSummary]
  type TrialComponentArtifacts =
    Map[TrialComponentKey64, zio.aws.sagemaker.model.TrialComponentArtifact]
  type TrialComponentMetricSummaries =
    List[zio.aws.sagemaker.model.TrialComponentMetricSummary]
  type TrialComponentParameters = Map[
    TrialComponentKey256,
    zio.aws.sagemaker.model.TrialComponentParameterValue
  ]
  type TrialComponentSimpleSummaries =
    List[zio.aws.sagemaker.model.TrialComponentSimpleSummary]
  type TrialComponentSummaries =
    List[zio.aws.sagemaker.model.TrialComponentSummary]
  type TrialSummaries = List[zio.aws.sagemaker.model.TrialSummary]
  type UserProfileList = List[zio.aws.sagemaker.model.UserProfileDetails]
  type VariantPropertyList = List[zio.aws.sagemaker.model.VariantProperty]
  type Vertices = List[zio.aws.sagemaker.model.Vertex]
  type VpcSecurityGroupIds = List[SecurityGroupId]
  type WorkforceSecurityGroupIds = List[WorkforceSecurityGroupId]
  type WorkforceSubnets = List[WorkforceSubnetId]
  type Workforces = List[zio.aws.sagemaker.model.Workforce]
  type Workteams = List[zio.aws.sagemaker.model.Workteam]
}
