package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait WorkforceStatus {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.WorkforceStatus
}
object WorkforceStatus {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.WorkforceStatus
  ): zio.aws.sagemaker.model.WorkforceStatus = value match {
    case software.amazon.awssdk.services.sagemaker.model.WorkforceStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.WorkforceStatus.INITIALIZING =>
      val r = Initializing
      r
    case software.amazon.awssdk.services.sagemaker.model.WorkforceStatus.UPDATING =>
      val r = Updating
      r
    case software.amazon.awssdk.services.sagemaker.model.WorkforceStatus.DELETING =>
      val r = Deleting
      r
    case software.amazon.awssdk.services.sagemaker.model.WorkforceStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.sagemaker.model.WorkforceStatus.ACTIVE =>
      val r = Active
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.WorkforceStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.WorkforceStatus =
      software.amazon.awssdk.services.sagemaker.model.WorkforceStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Initializing extends zio.aws.sagemaker.model.WorkforceStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.WorkforceStatus =
      software.amazon.awssdk.services.sagemaker.model.WorkforceStatus.INITIALIZING
  }
  case object Updating extends zio.aws.sagemaker.model.WorkforceStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.WorkforceStatus =
      software.amazon.awssdk.services.sagemaker.model.WorkforceStatus.UPDATING
  }
  case object Deleting extends zio.aws.sagemaker.model.WorkforceStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.WorkforceStatus =
      software.amazon.awssdk.services.sagemaker.model.WorkforceStatus.DELETING
  }
  case object Failed extends zio.aws.sagemaker.model.WorkforceStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.WorkforceStatus =
      software.amazon.awssdk.services.sagemaker.model.WorkforceStatus.FAILED
  }
  case object Active extends zio.aws.sagemaker.model.WorkforceStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.WorkforceStatus =
      software.amazon.awssdk.services.sagemaker.model.WorkforceStatus.ACTIVE
  }
}
