package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  KmsKeyId,
  VolumeSizeInGB,
  TrainingInstanceCount
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ResourceConfig(
    instanceType: Optional[zio.aws.sagemaker.model.TrainingInstanceType] =
      Optional.Absent,
    instanceCount: Optional[TrainingInstanceCount] = Optional.Absent,
    volumeSizeInGB: VolumeSizeInGB,
    volumeKmsKeyId: Optional[KmsKeyId] = Optional.Absent,
    instanceGroups: Optional[Iterable[zio.aws.sagemaker.model.InstanceGroup]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ResourceConfig = {
    import ResourceConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ResourceConfig
      .builder()
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(
        instanceCount.map(value => TrainingInstanceCount.unwrap(value): Integer)
      )(_.instanceCount)
      .volumeSizeInGB(VolumeSizeInGB.unwrap(volumeSizeInGB): Integer)
      .optionallyWith(
        volumeKmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.volumeKmsKeyId)
      .optionallyWith(
        instanceGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instanceGroups)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ResourceConfig.ReadOnly =
    zio.aws.sagemaker.model.ResourceConfig.wrap(buildAwsValue())
}
object ResourceConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ResourceConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ResourceConfig =
      zio.aws.sagemaker.model.ResourceConfig(
        instanceType.map(value => value),
        instanceCount.map(value => value),
        volumeSizeInGB,
        volumeKmsKeyId.map(value => value),
        instanceGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def instanceType: Optional[zio.aws.sagemaker.model.TrainingInstanceType]
    def instanceCount: Optional[TrainingInstanceCount]
    def volumeSizeInGB: VolumeSizeInGB
    def volumeKmsKeyId: Optional[KmsKeyId]
    def instanceGroups
        : Optional[List[zio.aws.sagemaker.model.InstanceGroup.ReadOnly]]
    def getInstanceType
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.TrainingInstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getInstanceCount: ZIO[Any, AwsError, TrainingInstanceCount] =
      AwsError.unwrapOptionField("instanceCount", instanceCount)
    def getVolumeSizeInGB: ZIO[Any, Nothing, VolumeSizeInGB] =
      ZIO.succeed(volumeSizeInGB)
    def getVolumeKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("volumeKmsKeyId", volumeKmsKeyId)
    def getInstanceGroups: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.InstanceGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("instanceGroups", instanceGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ResourceConfig
  ) extends zio.aws.sagemaker.model.ResourceConfig.ReadOnly {
    override val instanceType
        : Optional[zio.aws.sagemaker.model.TrainingInstanceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceType())
        .map(value => zio.aws.sagemaker.model.TrainingInstanceType.wrap(value))
    override val instanceCount: Optional[TrainingInstanceCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceCount())
        .map(value =>
          zio.aws.sagemaker.model.primitives.TrainingInstanceCount(value)
        )
    override val volumeSizeInGB: VolumeSizeInGB =
      zio.aws.sagemaker.model.primitives.VolumeSizeInGB(impl.volumeSizeInGB())
    override val volumeKmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeKmsKeyId())
      .map(value => zio.aws.sagemaker.model.primitives.KmsKeyId(value))
    override val instanceGroups
        : Optional[List[zio.aws.sagemaker.model.InstanceGroup.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.InstanceGroup.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ResourceConfig
  ): zio.aws.sagemaker.model.ResourceConfig.ReadOnly = new Wrapper(impl)
}
