package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.TrainingJobName
import scala.jdk.CollectionConverters._
final case class DescribeTrainingJobRequest(trainingJobName: TrainingJobName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeTrainingJobRequest = {
    import DescribeTrainingJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeTrainingJobRequest
      .builder()
      .trainingJobName(
        TrainingJobName.unwrap(trainingJobName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeTrainingJobRequest.ReadOnly =
    zio.aws.sagemaker.model.DescribeTrainingJobRequest.wrap(buildAwsValue())
}
object DescribeTrainingJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeTrainingJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeTrainingJobRequest =
      zio.aws.sagemaker.model.DescribeTrainingJobRequest(trainingJobName)
    def trainingJobName: TrainingJobName
    def getTrainingJobName: ZIO[Any, Nothing, TrainingJobName] =
      ZIO.succeed(trainingJobName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeTrainingJobRequest
  ) extends zio.aws.sagemaker.model.DescribeTrainingJobRequest.ReadOnly {
    override val trainingJobName: TrainingJobName =
      zio.aws.sagemaker.model.primitives.TrainingJobName(impl.trainingJobName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeTrainingJobRequest
  ): zio.aws.sagemaker.model.DescribeTrainingJobRequest.ReadOnly = new Wrapper(
    impl
  )
}
