package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.{ParameterValue, ParameterKey}
import scala.jdk.CollectionConverters._
final case class CategoricalParameterRange(
    name: ParameterKey,
    values: Iterable[ParameterValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CategoricalParameterRange = {
    import CategoricalParameterRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CategoricalParameterRange
      .builder()
      .name(ParameterKey.unwrap(name): java.lang.String)
      .values(values.map { item =>
        ParameterValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CategoricalParameterRange.ReadOnly =
    zio.aws.sagemaker.model.CategoricalParameterRange.wrap(buildAwsValue())
}
object CategoricalParameterRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CategoricalParameterRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CategoricalParameterRange =
      zio.aws.sagemaker.model.CategoricalParameterRange(name, values)
    def name: ParameterKey
    def values: List[ParameterValue]
    def getName: ZIO[Any, Nothing, ParameterKey] = ZIO.succeed(name)
    def getValues: ZIO[Any, Nothing, List[ParameterValue]] = ZIO.succeed(values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CategoricalParameterRange
  ) extends zio.aws.sagemaker.model.CategoricalParameterRange.ReadOnly {
    override val name: ParameterKey =
      zio.aws.sagemaker.model.primitives.ParameterKey(impl.name())
    override val values: List[ParameterValue] = impl
      .values()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.primitives.ParameterValue(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CategoricalParameterRange
  ): zio.aws.sagemaker.model.CategoricalParameterRange.ReadOnly = new Wrapper(
    impl
  )
}
