package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait SearchSortOrder {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.SearchSortOrder
}
object SearchSortOrder {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.SearchSortOrder
  ): zio.aws.sagemaker.model.SearchSortOrder = value match {
    case software.amazon.awssdk.services.sagemaker.model.SearchSortOrder.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.SearchSortOrder.ASCENDING =>
      val r = Ascending
      r
    case software.amazon.awssdk.services.sagemaker.model.SearchSortOrder.DESCENDING =>
      val r = Descending
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.SearchSortOrder {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.SearchSortOrder =
      software.amazon.awssdk.services.sagemaker.model.SearchSortOrder.UNKNOWN_TO_SDK_VERSION
  }
  case object Ascending extends zio.aws.sagemaker.model.SearchSortOrder {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.SearchSortOrder =
      software.amazon.awssdk.services.sagemaker.model.SearchSortOrder.ASCENDING
  }
  case object Descending extends zio.aws.sagemaker.model.SearchSortOrder {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.SearchSortOrder =
      software.amazon.awssdk.services.sagemaker.model.SearchSortOrder.DESCENDING
  }
}
