package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  KmsKeyId,
  JobDurationInSeconds,
  ModelPackageArn
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class RecommendationJobInputConfig(
    modelPackageVersionArn: ModelPackageArn,
    jobDurationInSeconds: Optional[JobDurationInSeconds] = Optional.Absent,
    trafficPattern: Optional[zio.aws.sagemaker.model.TrafficPattern] =
      Optional.Absent,
    resourceLimit: Optional[
      zio.aws.sagemaker.model.RecommendationJobResourceLimit
    ] = Optional.Absent,
    endpointConfigurations: Optional[
      Iterable[zio.aws.sagemaker.model.EndpointInputConfiguration]
    ] = Optional.Absent,
    volumeKmsKeyId: Optional[KmsKeyId] = Optional.Absent,
    containerConfig: Optional[
      zio.aws.sagemaker.model.RecommendationJobContainerConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.RecommendationJobInputConfig = {
    import RecommendationJobInputConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.RecommendationJobInputConfig
      .builder()
      .modelPackageVersionArn(
        ModelPackageArn.unwrap(modelPackageVersionArn): java.lang.String
      )
      .optionallyWith(
        jobDurationInSeconds.map(value =>
          JobDurationInSeconds.unwrap(value): Integer
        )
      )(_.jobDurationInSeconds)
      .optionallyWith(trafficPattern.map(value => value.buildAwsValue()))(
        _.trafficPattern
      )
      .optionallyWith(resourceLimit.map(value => value.buildAwsValue()))(
        _.resourceLimit
      )
      .optionallyWith(
        endpointConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.endpointConfigurations)
      .optionallyWith(
        volumeKmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.volumeKmsKeyId)
      .optionallyWith(containerConfig.map(value => value.buildAwsValue()))(
        _.containerConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.RecommendationJobInputConfig.ReadOnly =
    zio.aws.sagemaker.model.RecommendationJobInputConfig.wrap(buildAwsValue())
}
object RecommendationJobInputConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.RecommendationJobInputConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.RecommendationJobInputConfig =
      zio.aws.sagemaker.model.RecommendationJobInputConfig(
        modelPackageVersionArn,
        jobDurationInSeconds.map(value => value),
        trafficPattern.map(value => value.asEditable),
        resourceLimit.map(value => value.asEditable),
        endpointConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        volumeKmsKeyId.map(value => value),
        containerConfig.map(value => value.asEditable)
      )
    def modelPackageVersionArn: ModelPackageArn
    def jobDurationInSeconds: Optional[JobDurationInSeconds]
    def trafficPattern
        : Optional[zio.aws.sagemaker.model.TrafficPattern.ReadOnly]
    def resourceLimit: Optional[
      zio.aws.sagemaker.model.RecommendationJobResourceLimit.ReadOnly
    ]
    def endpointConfigurations: Optional[
      List[zio.aws.sagemaker.model.EndpointInputConfiguration.ReadOnly]
    ]
    def volumeKmsKeyId: Optional[KmsKeyId]
    def containerConfig: Optional[
      zio.aws.sagemaker.model.RecommendationJobContainerConfig.ReadOnly
    ]
    def getModelPackageVersionArn: ZIO[Any, Nothing, ModelPackageArn] =
      ZIO.succeed(modelPackageVersionArn)
    def getJobDurationInSeconds: ZIO[Any, AwsError, JobDurationInSeconds] =
      AwsError.unwrapOptionField("jobDurationInSeconds", jobDurationInSeconds)
    def getTrafficPattern
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.TrafficPattern.ReadOnly] =
      AwsError.unwrapOptionField("trafficPattern", trafficPattern)
    def getResourceLimit: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.RecommendationJobResourceLimit.ReadOnly
    ] = AwsError.unwrapOptionField("resourceLimit", resourceLimit)
    def getEndpointConfigurations: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.EndpointInputConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "endpointConfigurations",
      endpointConfigurations
    )
    def getVolumeKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("volumeKmsKeyId", volumeKmsKeyId)
    def getContainerConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.RecommendationJobContainerConfig.ReadOnly
    ] = AwsError.unwrapOptionField("containerConfig", containerConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.RecommendationJobInputConfig
  ) extends zio.aws.sagemaker.model.RecommendationJobInputConfig.ReadOnly {
    override val modelPackageVersionArn: ModelPackageArn =
      zio.aws.sagemaker.model.primitives
        .ModelPackageArn(impl.modelPackageVersionArn())
    override val jobDurationInSeconds: Optional[JobDurationInSeconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobDurationInSeconds())
        .map(value =>
          zio.aws.sagemaker.model.primitives.JobDurationInSeconds(value)
        )
    override val trafficPattern
        : Optional[zio.aws.sagemaker.model.TrafficPattern.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trafficPattern())
        .map(value => zio.aws.sagemaker.model.TrafficPattern.wrap(value))
    override val resourceLimit: Optional[
      zio.aws.sagemaker.model.RecommendationJobResourceLimit.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceLimit())
      .map(value =>
        zio.aws.sagemaker.model.RecommendationJobResourceLimit.wrap(value)
      )
    override val endpointConfigurations: Optional[
      List[zio.aws.sagemaker.model.EndpointInputConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.endpointConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.EndpointInputConfiguration.wrap(item)
        }.toList
      )
    override val volumeKmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeKmsKeyId())
      .map(value => zio.aws.sagemaker.model.primitives.KmsKeyId(value))
    override val containerConfig: Optional[
      zio.aws.sagemaker.model.RecommendationJobContainerConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.containerConfig())
      .map(value =>
        zio.aws.sagemaker.model.RecommendationJobContainerConfig.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.RecommendationJobInputConfig
  ): zio.aws.sagemaker.model.RecommendationJobInputConfig.ReadOnly =
    new Wrapper(impl)
}
