package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait ProcessingJobStatus {
  def unwrap
      : software.amazon.awssdk.services.sagemaker.model.ProcessingJobStatus
}
object ProcessingJobStatus {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.ProcessingJobStatus
  ): zio.aws.sagemaker.model.ProcessingJobStatus = value match {
    case software.amazon.awssdk.services.sagemaker.model.ProcessingJobStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.ProcessingJobStatus.IN_PROGRESS =>
      val r = InProgress
      r
    case software.amazon.awssdk.services.sagemaker.model.ProcessingJobStatus.COMPLETED =>
      val r = Completed
      r
    case software.amazon.awssdk.services.sagemaker.model.ProcessingJobStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.sagemaker.model.ProcessingJobStatus.STOPPING =>
      val r = Stopping
      r
    case software.amazon.awssdk.services.sagemaker.model.ProcessingJobStatus.STOPPED =>
      val r = Stopped
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.ProcessingJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProcessingJobStatus =
      software.amazon.awssdk.services.sagemaker.model.ProcessingJobStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object InProgress extends zio.aws.sagemaker.model.ProcessingJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProcessingJobStatus =
      software.amazon.awssdk.services.sagemaker.model.ProcessingJobStatus.IN_PROGRESS
  }
  case object Completed extends zio.aws.sagemaker.model.ProcessingJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProcessingJobStatus =
      software.amazon.awssdk.services.sagemaker.model.ProcessingJobStatus.COMPLETED
  }
  case object Failed extends zio.aws.sagemaker.model.ProcessingJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProcessingJobStatus =
      software.amazon.awssdk.services.sagemaker.model.ProcessingJobStatus.FAILED
  }
  case object Stopping extends zio.aws.sagemaker.model.ProcessingJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProcessingJobStatus =
      software.amazon.awssdk.services.sagemaker.model.ProcessingJobStatus.STOPPING
  }
  case object Stopped extends zio.aws.sagemaker.model.ProcessingJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ProcessingJobStatus =
      software.amazon.awssdk.services.sagemaker.model.ProcessingJobStatus.STOPPED
  }
}
