package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.ObjectiveStatusCounter
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ObjectiveStatusCounters(
    succeeded: Optional[ObjectiveStatusCounter] = Optional.Absent,
    pending: Optional[ObjectiveStatusCounter] = Optional.Absent,
    failed: Optional[ObjectiveStatusCounter] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ObjectiveStatusCounters = {
    import ObjectiveStatusCounters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ObjectiveStatusCounters
      .builder()
      .optionallyWith(
        succeeded.map(value => ObjectiveStatusCounter.unwrap(value): Integer)
      )(_.succeeded)
      .optionallyWith(
        pending.map(value => ObjectiveStatusCounter.unwrap(value): Integer)
      )(_.pending)
      .optionallyWith(
        failed.map(value => ObjectiveStatusCounter.unwrap(value): Integer)
      )(_.failed)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ObjectiveStatusCounters.ReadOnly =
    zio.aws.sagemaker.model.ObjectiveStatusCounters.wrap(buildAwsValue())
}
object ObjectiveStatusCounters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ObjectiveStatusCounters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ObjectiveStatusCounters =
      zio.aws.sagemaker.model.ObjectiveStatusCounters(
        succeeded.map(value => value),
        pending.map(value => value),
        failed.map(value => value)
      )
    def succeeded: Optional[ObjectiveStatusCounter]
    def pending: Optional[ObjectiveStatusCounter]
    def failed: Optional[ObjectiveStatusCounter]
    def getSucceeded: ZIO[Any, AwsError, ObjectiveStatusCounter] =
      AwsError.unwrapOptionField("succeeded", succeeded)
    def getPending: ZIO[Any, AwsError, ObjectiveStatusCounter] =
      AwsError.unwrapOptionField("pending", pending)
    def getFailed: ZIO[Any, AwsError, ObjectiveStatusCounter] =
      AwsError.unwrapOptionField("failed", failed)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ObjectiveStatusCounters
  ) extends zio.aws.sagemaker.model.ObjectiveStatusCounters.ReadOnly {
    override val succeeded: Optional[ObjectiveStatusCounter] =
      zio.aws.core.internal
        .optionalFromNullable(impl.succeeded())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ObjectiveStatusCounter(value)
        )
    override val pending: Optional[ObjectiveStatusCounter] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pending())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ObjectiveStatusCounter(value)
        )
    override val failed: Optional[ObjectiveStatusCounter] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failed())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ObjectiveStatusCounter(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ObjectiveStatusCounters
  ): zio.aws.sagemaker.model.ObjectiveStatusCounters.ReadOnly = new Wrapper(
    impl
  )
}
