package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{ProcessingLocalPath, MonitoringS3Uri}
import scala.jdk.CollectionConverters._
final case class MonitoringS3Output(
    s3Uri: MonitoringS3Uri,
    localPath: ProcessingLocalPath,
    s3UploadMode: Optional[zio.aws.sagemaker.model.ProcessingS3UploadMode] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.MonitoringS3Output = {
    import MonitoringS3Output.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.MonitoringS3Output
      .builder()
      .s3Uri(MonitoringS3Uri.unwrap(s3Uri): java.lang.String)
      .localPath(ProcessingLocalPath.unwrap(localPath): java.lang.String)
      .optionallyWith(s3UploadMode.map(value => value.unwrap))(_.s3UploadMode)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.MonitoringS3Output.ReadOnly =
    zio.aws.sagemaker.model.MonitoringS3Output.wrap(buildAwsValue())
}
object MonitoringS3Output {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.MonitoringS3Output
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.MonitoringS3Output =
      zio.aws.sagemaker.model
        .MonitoringS3Output(s3Uri, localPath, s3UploadMode.map(value => value))
    def s3Uri: MonitoringS3Uri
    def localPath: ProcessingLocalPath
    def s3UploadMode: Optional[zio.aws.sagemaker.model.ProcessingS3UploadMode]
    def getS3Uri: ZIO[Any, Nothing, MonitoringS3Uri] = ZIO.succeed(s3Uri)
    def getLocalPath: ZIO[Any, Nothing, ProcessingLocalPath] =
      ZIO.succeed(localPath)
    def getS3UploadMode
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ProcessingS3UploadMode] =
      AwsError.unwrapOptionField("s3UploadMode", s3UploadMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.MonitoringS3Output
  ) extends zio.aws.sagemaker.model.MonitoringS3Output.ReadOnly {
    override val s3Uri: MonitoringS3Uri =
      zio.aws.sagemaker.model.primitives.MonitoringS3Uri(impl.s3Uri())
    override val localPath: ProcessingLocalPath =
      zio.aws.sagemaker.model.primitives.ProcessingLocalPath(impl.localPath())
    override val s3UploadMode
        : Optional[zio.aws.sagemaker.model.ProcessingS3UploadMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3UploadMode())
        .map(value =>
          zio.aws.sagemaker.model.ProcessingS3UploadMode.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.MonitoringS3Output
  ): zio.aws.sagemaker.model.MonitoringS3Output.ReadOnly = new Wrapper(impl)
}
