package zio.aws.sagemaker.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.{
  InstanceGroupName,
  TrainingInstanceCount
}
import scala.jdk.CollectionConverters._
final case class InstanceGroup(
    instanceType: zio.aws.sagemaker.model.TrainingInstanceType,
    instanceCount: TrainingInstanceCount,
    instanceGroupName: InstanceGroupName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.InstanceGroup = {
    import InstanceGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.InstanceGroup
      .builder()
      .instanceType(instanceType.unwrap)
      .instanceCount(TrainingInstanceCount.unwrap(instanceCount): Integer)
      .instanceGroupName(
        InstanceGroupName.unwrap(instanceGroupName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.InstanceGroup.ReadOnly =
    zio.aws.sagemaker.model.InstanceGroup.wrap(buildAwsValue())
}
object InstanceGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.InstanceGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.InstanceGroup =
      zio.aws.sagemaker.model
        .InstanceGroup(instanceType, instanceCount, instanceGroupName)
    def instanceType: zio.aws.sagemaker.model.TrainingInstanceType
    def instanceCount: TrainingInstanceCount
    def instanceGroupName: InstanceGroupName
    def getInstanceType
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.TrainingInstanceType] =
      ZIO.succeed(instanceType)
    def getInstanceCount: ZIO[Any, Nothing, TrainingInstanceCount] =
      ZIO.succeed(instanceCount)
    def getInstanceGroupName: ZIO[Any, Nothing, InstanceGroupName] =
      ZIO.succeed(instanceGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.InstanceGroup
  ) extends zio.aws.sagemaker.model.InstanceGroup.ReadOnly {
    override val instanceType: zio.aws.sagemaker.model.TrainingInstanceType =
      zio.aws.sagemaker.model.TrainingInstanceType.wrap(impl.instanceType())
    override val instanceCount: TrainingInstanceCount =
      zio.aws.sagemaker.model.primitives
        .TrainingInstanceCount(impl.instanceCount())
    override val instanceGroupName: InstanceGroupName =
      zio.aws.sagemaker.model.primitives
        .InstanceGroupName(impl.instanceGroupName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.InstanceGroup
  ): zio.aws.sagemaker.model.InstanceGroup.ReadOnly = new Wrapper(impl)
}
