package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.EntityName
import scala.jdk.CollectionConverters._
final case class EdgeDeploymentModelConfig(
    modelHandle: EntityName,
    edgePackagingJobName: EntityName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.EdgeDeploymentModelConfig = {
    import EdgeDeploymentModelConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.EdgeDeploymentModelConfig
      .builder()
      .modelHandle(EntityName.unwrap(modelHandle): java.lang.String)
      .edgePackagingJobName(
        EntityName.unwrap(edgePackagingJobName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.EdgeDeploymentModelConfig.ReadOnly =
    zio.aws.sagemaker.model.EdgeDeploymentModelConfig.wrap(buildAwsValue())
}
object EdgeDeploymentModelConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.EdgeDeploymentModelConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.EdgeDeploymentModelConfig =
      zio.aws.sagemaker.model
        .EdgeDeploymentModelConfig(modelHandle, edgePackagingJobName)
    def modelHandle: EntityName
    def edgePackagingJobName: EntityName
    def getModelHandle: ZIO[Any, Nothing, EntityName] = ZIO.succeed(modelHandle)
    def getEdgePackagingJobName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(edgePackagingJobName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.EdgeDeploymentModelConfig
  ) extends zio.aws.sagemaker.model.EdgeDeploymentModelConfig.ReadOnly {
    override val modelHandle: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.modelHandle())
    override val edgePackagingJobName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.edgePackagingJobName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.EdgeDeploymentModelConfig
  ): zio.aws.sagemaker.model.EdgeDeploymentModelConfig.ReadOnly = new Wrapper(
    impl
  )
}
