package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DomainSettingsForUpdate(
    rStudioServerProDomainSettingsForUpdate: Optional[
      zio.aws.sagemaker.model.RStudioServerProDomainSettingsForUpdate
    ] = Optional.Absent,
    executionRoleIdentityConfig: Optional[
      zio.aws.sagemaker.model.ExecutionRoleIdentityConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DomainSettingsForUpdate = {
    import DomainSettingsForUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DomainSettingsForUpdate
      .builder()
      .optionallyWith(
        rStudioServerProDomainSettingsForUpdate.map(value =>
          value.buildAwsValue()
        )
      )(_.rStudioServerProDomainSettingsForUpdate)
      .optionallyWith(executionRoleIdentityConfig.map(value => value.unwrap))(
        _.executionRoleIdentityConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DomainSettingsForUpdate.ReadOnly =
    zio.aws.sagemaker.model.DomainSettingsForUpdate.wrap(buildAwsValue())
}
object DomainSettingsForUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DomainSettingsForUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DomainSettingsForUpdate =
      zio.aws.sagemaker.model.DomainSettingsForUpdate(
        rStudioServerProDomainSettingsForUpdate.map(value => value.asEditable),
        executionRoleIdentityConfig.map(value => value)
      )
    def rStudioServerProDomainSettingsForUpdate: Optional[
      zio.aws.sagemaker.model.RStudioServerProDomainSettingsForUpdate.ReadOnly
    ]
    def executionRoleIdentityConfig
        : Optional[zio.aws.sagemaker.model.ExecutionRoleIdentityConfig]
    def getRStudioServerProDomainSettingsForUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.RStudioServerProDomainSettingsForUpdate.ReadOnly
    ] = AwsError.unwrapOptionField(
      "rStudioServerProDomainSettingsForUpdate",
      rStudioServerProDomainSettingsForUpdate
    )
    def getExecutionRoleIdentityConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ExecutionRoleIdentityConfig
    ] = AwsError.unwrapOptionField(
      "executionRoleIdentityConfig",
      executionRoleIdentityConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DomainSettingsForUpdate
  ) extends zio.aws.sagemaker.model.DomainSettingsForUpdate.ReadOnly {
    override val rStudioServerProDomainSettingsForUpdate: Optional[
      zio.aws.sagemaker.model.RStudioServerProDomainSettingsForUpdate.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.rStudioServerProDomainSettingsForUpdate())
      .map(value =>
        zio.aws.sagemaker.model.RStudioServerProDomainSettingsForUpdate
          .wrap(value)
      )
    override val executionRoleIdentityConfig
        : Optional[zio.aws.sagemaker.model.ExecutionRoleIdentityConfig] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionRoleIdentityConfig())
        .map(value =>
          zio.aws.sagemaker.model.ExecutionRoleIdentityConfig.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DomainSettingsForUpdate
  ): zio.aws.sagemaker.model.DomainSettingsForUpdate.ReadOnly = new Wrapper(
    impl
  )
}
