package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.{String1024, String256}
import scala.jdk.CollectionConverters._
final case class OutputParameter(name: String256, value: String1024) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.OutputParameter = {
    import OutputParameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.OutputParameter
      .builder()
      .name(String256.unwrap(name): java.lang.String)
      .value(String1024.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.OutputParameter.ReadOnly =
    zio.aws.sagemaker.model.OutputParameter.wrap(buildAwsValue())
}
object OutputParameter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.OutputParameter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.OutputParameter =
      zio.aws.sagemaker.model.OutputParameter(name, value)
    def name: String256
    def value: String1024
    def getName: ZIO[Any, Nothing, String256] = ZIO.succeed(name)
    def getValue: ZIO[Any, Nothing, String1024] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.OutputParameter
  ) extends zio.aws.sagemaker.model.OutputParameter.ReadOnly {
    override val name: String256 =
      zio.aws.sagemaker.model.primitives.String256(impl.name())
    override val value: String1024 =
      zio.aws.sagemaker.model.primitives.String1024(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.OutputParameter
  ): zio.aws.sagemaker.model.OutputParameter.ReadOnly = new Wrapper(impl)
}
