package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{
  ContainerArgument,
  ContainerEntrypointString,
  ImageUri
}
import scala.jdk.CollectionConverters._
final case class AppSpecification(
    imageUri: ImageUri,
    containerEntrypoint: Optional[Iterable[ContainerEntrypointString]] =
      Optional.Absent,
    containerArguments: Optional[Iterable[ContainerArgument]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.AppSpecification = {
    import AppSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.AppSpecification
      .builder()
      .imageUri(ImageUri.unwrap(imageUri): java.lang.String)
      .optionallyWith(
        containerEntrypoint.map(value =>
          value.map { item =>
            ContainerEntrypointString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.containerEntrypoint)
      .optionallyWith(
        containerArguments.map(value =>
          value.map { item =>
            ContainerArgument.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.containerArguments)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.AppSpecification.ReadOnly =
    zio.aws.sagemaker.model.AppSpecification.wrap(buildAwsValue())
}
object AppSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.AppSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.AppSpecification =
      zio.aws.sagemaker.model.AppSpecification(
        imageUri,
        containerEntrypoint.map(value => value),
        containerArguments.map(value => value)
      )
    def imageUri: ImageUri
    def containerEntrypoint: Optional[List[ContainerEntrypointString]]
    def containerArguments: Optional[List[ContainerArgument]]
    def getImageUri: ZIO[Any, Nothing, ImageUri] = ZIO.succeed(imageUri)
    def getContainerEntrypoint
        : ZIO[Any, AwsError, List[ContainerEntrypointString]] =
      AwsError.unwrapOptionField("containerEntrypoint", containerEntrypoint)
    def getContainerArguments: ZIO[Any, AwsError, List[ContainerArgument]] =
      AwsError.unwrapOptionField("containerArguments", containerArguments)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.AppSpecification
  ) extends zio.aws.sagemaker.model.AppSpecification.ReadOnly {
    override val imageUri: ImageUri =
      zio.aws.sagemaker.model.primitives.ImageUri(impl.imageUri())
    override val containerEntrypoint
        : Optional[List[ContainerEntrypointString]] = zio.aws.core.internal
      .optionalFromNullable(impl.containerEntrypoint())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.primitives.ContainerEntrypointString(item)
        }.toList
      )
    override val containerArguments: Optional[List[ContainerArgument]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.containerArguments())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.primitives.ContainerArgument(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.AppSpecification
  ): zio.aws.sagemaker.model.AppSpecification.ReadOnly = new Wrapper(impl)
}
