package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UserContext(
    userProfileArn: Optional[String] = Optional.Absent,
    userProfileName: Optional[String] = Optional.Absent,
    domainId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UserContext = {
    import UserContext.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UserContext
      .builder()
      .optionallyWith(userProfileArn.map(value => value: java.lang.String))(
        _.userProfileArn
      )
      .optionallyWith(userProfileName.map(value => value: java.lang.String))(
        _.userProfileName
      )
      .optionallyWith(domainId.map(value => value: java.lang.String))(
        _.domainId
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.UserContext.ReadOnly =
    zio.aws.sagemaker.model.UserContext.wrap(buildAwsValue())
}
object UserContext {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UserContext
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UserContext =
      zio.aws.sagemaker.model.UserContext(
        userProfileArn.map(value => value),
        userProfileName.map(value => value),
        domainId.map(value => value)
      )
    def userProfileArn: Optional[String]
    def userProfileName: Optional[String]
    def domainId: Optional[String]
    def getUserProfileArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("userProfileArn", userProfileArn)
    def getUserProfileName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("userProfileName", userProfileName)
    def getDomainId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("domainId", domainId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UserContext
  ) extends zio.aws.sagemaker.model.UserContext.ReadOnly {
    override val userProfileArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.userProfileArn())
      .map(value => value: String)
    override val userProfileName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.userProfileName())
      .map(value => value: String)
    override val domainId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.domainId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UserContext
  ): zio.aws.sagemaker.model.UserContext.ReadOnly = new Wrapper(impl)
}
