package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  RoleArn,
  LabelingJobArn,
  S3Uri,
  Timestamp,
  FailureReason,
  LabelAttributeName,
  LabelingJobName,
  JobReferenceCode
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeLabelingJobResponse(
    labelingJobStatus: zio.aws.sagemaker.model.LabelingJobStatus,
    labelCounters: zio.aws.sagemaker.model.LabelCounters,
    failureReason: Optional[FailureReason] = Optional.Absent,
    creationTime: Timestamp,
    lastModifiedTime: Timestamp,
    jobReferenceCode: JobReferenceCode,
    labelingJobName: LabelingJobName,
    labelingJobArn: LabelingJobArn,
    labelAttributeName: Optional[LabelAttributeName] = Optional.Absent,
    inputConfig: zio.aws.sagemaker.model.LabelingJobInputConfig,
    outputConfig: zio.aws.sagemaker.model.LabelingJobOutputConfig,
    roleArn: RoleArn,
    labelCategoryConfigS3Uri: Optional[S3Uri] = Optional.Absent,
    stoppingConditions: Optional[
      zio.aws.sagemaker.model.LabelingJobStoppingConditions
    ] = Optional.Absent,
    labelingJobAlgorithmsConfig: Optional[
      zio.aws.sagemaker.model.LabelingJobAlgorithmsConfig
    ] = Optional.Absent,
    humanTaskConfig: zio.aws.sagemaker.model.HumanTaskConfig,
    tags: Optional[Iterable[zio.aws.sagemaker.model.Tag]] = Optional.Absent,
    labelingJobOutput: Optional[zio.aws.sagemaker.model.LabelingJobOutput] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeLabelingJobResponse = {
    import DescribeLabelingJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeLabelingJobResponse
      .builder()
      .labelingJobStatus(labelingJobStatus.unwrap)
      .labelCounters(labelCounters.buildAwsValue())
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .lastModifiedTime(Timestamp.unwrap(lastModifiedTime): Instant)
      .jobReferenceCode(
        JobReferenceCode.unwrap(jobReferenceCode): java.lang.String
      )
      .labelingJobName(
        LabelingJobName.unwrap(labelingJobName): java.lang.String
      )
      .labelingJobArn(LabelingJobArn.unwrap(labelingJobArn): java.lang.String)
      .optionallyWith(
        labelAttributeName.map(value =>
          LabelAttributeName.unwrap(value): java.lang.String
        )
      )(_.labelAttributeName)
      .inputConfig(inputConfig.buildAwsValue())
      .outputConfig(outputConfig.buildAwsValue())
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        labelCategoryConfigS3Uri.map(value =>
          S3Uri.unwrap(value): java.lang.String
        )
      )(_.labelCategoryConfigS3Uri)
      .optionallyWith(stoppingConditions.map(value => value.buildAwsValue()))(
        _.stoppingConditions
      )
      .optionallyWith(
        labelingJobAlgorithmsConfig.map(value => value.buildAwsValue())
      )(_.labelingJobAlgorithmsConfig)
      .humanTaskConfig(humanTaskConfig.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(labelingJobOutput.map(value => value.buildAwsValue()))(
        _.labelingJobOutput
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeLabelingJobResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeLabelingJobResponse.wrap(buildAwsValue())
}
object DescribeLabelingJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeLabelingJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeLabelingJobResponse =
      zio.aws.sagemaker.model.DescribeLabelingJobResponse(
        labelingJobStatus,
        labelCounters.asEditable,
        failureReason.map(value => value),
        creationTime,
        lastModifiedTime,
        jobReferenceCode,
        labelingJobName,
        labelingJobArn,
        labelAttributeName.map(value => value),
        inputConfig.asEditable,
        outputConfig.asEditable,
        roleArn,
        labelCategoryConfigS3Uri.map(value => value),
        stoppingConditions.map(value => value.asEditable),
        labelingJobAlgorithmsConfig.map(value => value.asEditable),
        humanTaskConfig.asEditable,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        labelingJobOutput.map(value => value.asEditable)
      )
    def labelingJobStatus: zio.aws.sagemaker.model.LabelingJobStatus
    def labelCounters: zio.aws.sagemaker.model.LabelCounters.ReadOnly
    def failureReason: Optional[FailureReason]
    def creationTime: Timestamp
    def lastModifiedTime: Timestamp
    def jobReferenceCode: JobReferenceCode
    def labelingJobName: LabelingJobName
    def labelingJobArn: LabelingJobArn
    def labelAttributeName: Optional[LabelAttributeName]
    def inputConfig: zio.aws.sagemaker.model.LabelingJobInputConfig.ReadOnly
    def outputConfig: zio.aws.sagemaker.model.LabelingJobOutputConfig.ReadOnly
    def roleArn: RoleArn
    def labelCategoryConfigS3Uri: Optional[S3Uri]
    def stoppingConditions: Optional[
      zio.aws.sagemaker.model.LabelingJobStoppingConditions.ReadOnly
    ]
    def labelingJobAlgorithmsConfig
        : Optional[zio.aws.sagemaker.model.LabelingJobAlgorithmsConfig.ReadOnly]
    def humanTaskConfig: zio.aws.sagemaker.model.HumanTaskConfig.ReadOnly
    def tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def labelingJobOutput
        : Optional[zio.aws.sagemaker.model.LabelingJobOutput.ReadOnly]
    def getLabelingJobStatus
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.LabelingJobStatus] =
      ZIO.succeed(labelingJobStatus)
    def getLabelCounters
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.LabelCounters.ReadOnly] =
      ZIO.succeed(labelCounters)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getLastModifiedTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModifiedTime)
    def getJobReferenceCode: ZIO[Any, Nothing, JobReferenceCode] =
      ZIO.succeed(jobReferenceCode)
    def getLabelingJobName: ZIO[Any, Nothing, LabelingJobName] =
      ZIO.succeed(labelingJobName)
    def getLabelingJobArn: ZIO[Any, Nothing, LabelingJobArn] =
      ZIO.succeed(labelingJobArn)
    def getLabelAttributeName: ZIO[Any, AwsError, LabelAttributeName] =
      AwsError.unwrapOptionField("labelAttributeName", labelAttributeName)
    def getInputConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.LabelingJobInputConfig.ReadOnly
    ] = ZIO.succeed(inputConfig)
    def getOutputConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.LabelingJobOutputConfig.ReadOnly
    ] = ZIO.succeed(outputConfig)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getLabelCategoryConfigS3Uri: ZIO[Any, AwsError, S3Uri] = AwsError
      .unwrapOptionField("labelCategoryConfigS3Uri", labelCategoryConfigS3Uri)
    def getStoppingConditions: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.LabelingJobStoppingConditions.ReadOnly
    ] = AwsError.unwrapOptionField("stoppingConditions", stoppingConditions)
    def getLabelingJobAlgorithmsConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.LabelingJobAlgorithmsConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "labelingJobAlgorithmsConfig",
      labelingJobAlgorithmsConfig
    )
    def getHumanTaskConfig
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.HumanTaskConfig.ReadOnly] =
      ZIO.succeed(humanTaskConfig)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getLabelingJobOutput: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.LabelingJobOutput.ReadOnly
    ] = AwsError.unwrapOptionField("labelingJobOutput", labelingJobOutput)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeLabelingJobResponse
  ) extends zio.aws.sagemaker.model.DescribeLabelingJobResponse.ReadOnly {
    override val labelingJobStatus: zio.aws.sagemaker.model.LabelingJobStatus =
      zio.aws.sagemaker.model.LabelingJobStatus.wrap(impl.labelingJobStatus())
    override val labelCounters: zio.aws.sagemaker.model.LabelCounters.ReadOnly =
      zio.aws.sagemaker.model.LabelCounters.wrap(impl.labelCounters())
    override val failureReason: Optional[FailureReason] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => zio.aws.sagemaker.model.primitives.FailureReason(value))
    override val creationTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.creationTime())
    override val lastModifiedTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.lastModifiedTime())
    override val jobReferenceCode: JobReferenceCode =
      zio.aws.sagemaker.model.primitives
        .JobReferenceCode(impl.jobReferenceCode())
    override val labelingJobName: LabelingJobName =
      zio.aws.sagemaker.model.primitives.LabelingJobName(impl.labelingJobName())
    override val labelingJobArn: LabelingJobArn =
      zio.aws.sagemaker.model.primitives.LabelingJobArn(impl.labelingJobArn())
    override val labelAttributeName: Optional[LabelAttributeName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.labelAttributeName())
        .map(value =>
          zio.aws.sagemaker.model.primitives.LabelAttributeName(value)
        )
    override val inputConfig
        : zio.aws.sagemaker.model.LabelingJobInputConfig.ReadOnly =
      zio.aws.sagemaker.model.LabelingJobInputConfig.wrap(impl.inputConfig())
    override val outputConfig
        : zio.aws.sagemaker.model.LabelingJobOutputConfig.ReadOnly =
      zio.aws.sagemaker.model.LabelingJobOutputConfig.wrap(impl.outputConfig())
    override val roleArn: RoleArn =
      zio.aws.sagemaker.model.primitives.RoleArn(impl.roleArn())
    override val labelCategoryConfigS3Uri: Optional[S3Uri] =
      zio.aws.core.internal
        .optionalFromNullable(impl.labelCategoryConfigS3Uri())
        .map(value => zio.aws.sagemaker.model.primitives.S3Uri(value))
    override val stoppingConditions: Optional[
      zio.aws.sagemaker.model.LabelingJobStoppingConditions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.stoppingConditions())
      .map(value =>
        zio.aws.sagemaker.model.LabelingJobStoppingConditions.wrap(value)
      )
    override val labelingJobAlgorithmsConfig: Optional[
      zio.aws.sagemaker.model.LabelingJobAlgorithmsConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.labelingJobAlgorithmsConfig())
      .map(value =>
        zio.aws.sagemaker.model.LabelingJobAlgorithmsConfig.wrap(value)
      )
    override val humanTaskConfig
        : zio.aws.sagemaker.model.HumanTaskConfig.ReadOnly =
      zio.aws.sagemaker.model.HumanTaskConfig.wrap(impl.humanTaskConfig())
    override val tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
    override val labelingJobOutput
        : Optional[zio.aws.sagemaker.model.LabelingJobOutput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.labelingJobOutput())
        .map(value => zio.aws.sagemaker.model.LabelingJobOutput.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeLabelingJobResponse
  ): zio.aws.sagemaker.model.DescribeLabelingJobResponse.ReadOnly = new Wrapper(
    impl
  )
}
