package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  ExperimentDescription,
  ExperimentEntityNameOrArn,
  Timestamp,
  ActionArn,
  LineageGroupArn,
  String256,
  StringParameterValue
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeActionResponse(
    actionName: Optional[ExperimentEntityNameOrArn] = Optional.Absent,
    actionArn: Optional[ActionArn] = Optional.Absent,
    source: Optional[zio.aws.sagemaker.model.ActionSource] = Optional.Absent,
    actionType: Optional[String256] = Optional.Absent,
    description: Optional[ExperimentDescription] = Optional.Absent,
    status: Optional[zio.aws.sagemaker.model.ActionStatus] = Optional.Absent,
    properties: Optional[Map[StringParameterValue, StringParameterValue]] =
      Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    createdBy: Optional[zio.aws.sagemaker.model.UserContext] = Optional.Absent,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent,
    lastModifiedBy: Optional[zio.aws.sagemaker.model.UserContext] =
      Optional.Absent,
    metadataProperties: Optional[zio.aws.sagemaker.model.MetadataProperties] =
      Optional.Absent,
    lineageGroupArn: Optional[LineageGroupArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeActionResponse = {
    import DescribeActionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeActionResponse
      .builder()
      .optionallyWith(
        actionName.map(value =>
          ExperimentEntityNameOrArn.unwrap(value): java.lang.String
        )
      )(_.actionName)
      .optionallyWith(
        actionArn.map(value => ActionArn.unwrap(value): java.lang.String)
      )(_.actionArn)
      .optionallyWith(source.map(value => value.buildAwsValue()))(_.source)
      .optionallyWith(
        actionType.map(value => String256.unwrap(value): java.lang.String)
      )(_.actionType)
      .optionallyWith(
        description.map(value =>
          ExperimentDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        properties.map(value =>
          value
            .map({ case (key, value) =>
              (StringParameterValue.unwrap(
                key
              ): java.lang.String) -> (StringParameterValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.properties)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(createdBy.map(value => value.buildAwsValue()))(
        _.createdBy
      )
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(lastModifiedBy.map(value => value.buildAwsValue()))(
        _.lastModifiedBy
      )
      .optionallyWith(metadataProperties.map(value => value.buildAwsValue()))(
        _.metadataProperties
      )
      .optionallyWith(
        lineageGroupArn.map(value =>
          LineageGroupArn.unwrap(value): java.lang.String
        )
      )(_.lineageGroupArn)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeActionResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeActionResponse.wrap(buildAwsValue())
}
object DescribeActionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeActionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeActionResponse =
      zio.aws.sagemaker.model.DescribeActionResponse(
        actionName.map(value => value),
        actionArn.map(value => value),
        source.map(value => value.asEditable),
        actionType.map(value => value),
        description.map(value => value),
        status.map(value => value),
        properties.map(value => value),
        creationTime.map(value => value),
        createdBy.map(value => value.asEditable),
        lastModifiedTime.map(value => value),
        lastModifiedBy.map(value => value.asEditable),
        metadataProperties.map(value => value.asEditable),
        lineageGroupArn.map(value => value)
      )
    def actionName: Optional[ExperimentEntityNameOrArn]
    def actionArn: Optional[ActionArn]
    def source: Optional[zio.aws.sagemaker.model.ActionSource.ReadOnly]
    def actionType: Optional[String256]
    def description: Optional[ExperimentDescription]
    def status: Optional[zio.aws.sagemaker.model.ActionStatus]
    def properties: Optional[Map[StringParameterValue, StringParameterValue]]
    def creationTime: Optional[Timestamp]
    def createdBy: Optional[zio.aws.sagemaker.model.UserContext.ReadOnly]
    def lastModifiedTime: Optional[Timestamp]
    def lastModifiedBy: Optional[zio.aws.sagemaker.model.UserContext.ReadOnly]
    def metadataProperties
        : Optional[zio.aws.sagemaker.model.MetadataProperties.ReadOnly]
    def lineageGroupArn: Optional[LineageGroupArn]
    def getActionName: ZIO[Any, AwsError, ExperimentEntityNameOrArn] =
      AwsError.unwrapOptionField("actionName", actionName)
    def getActionArn: ZIO[Any, AwsError, ActionArn] =
      AwsError.unwrapOptionField("actionArn", actionArn)
    def getSource
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ActionSource.ReadOnly] =
      AwsError.unwrapOptionField("source", source)
    def getActionType: ZIO[Any, AwsError, String256] =
      AwsError.unwrapOptionField("actionType", actionType)
    def getDescription: ZIO[Any, AwsError, ExperimentDescription] =
      AwsError.unwrapOptionField("description", description)
    def getStatus: ZIO[Any, AwsError, zio.aws.sagemaker.model.ActionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getProperties
        : ZIO[Any, AwsError, Map[StringParameterValue, StringParameterValue]] =
      AwsError.unwrapOptionField("properties", properties)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getCreatedBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UserContext.ReadOnly] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getLastModifiedBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UserContext.ReadOnly] =
      AwsError.unwrapOptionField("lastModifiedBy", lastModifiedBy)
    def getMetadataProperties: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.MetadataProperties.ReadOnly
    ] = AwsError.unwrapOptionField("metadataProperties", metadataProperties)
    def getLineageGroupArn: ZIO[Any, AwsError, LineageGroupArn] =
      AwsError.unwrapOptionField("lineageGroupArn", lineageGroupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeActionResponse
  ) extends zio.aws.sagemaker.model.DescribeActionResponse.ReadOnly {
    override val actionName: Optional[ExperimentEntityNameOrArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actionName())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ExperimentEntityNameOrArn(value)
        )
    override val actionArn: Optional[ActionArn] = zio.aws.core.internal
      .optionalFromNullable(impl.actionArn())
      .map(value => zio.aws.sagemaker.model.primitives.ActionArn(value))
    override val source
        : Optional[zio.aws.sagemaker.model.ActionSource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.source())
        .map(value => zio.aws.sagemaker.model.ActionSource.wrap(value))
    override val actionType: Optional[String256] = zio.aws.core.internal
      .optionalFromNullable(impl.actionType())
      .map(value => zio.aws.sagemaker.model.primitives.String256(value))
    override val description: Optional[ExperimentDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ExperimentDescription(value)
        )
    override val status: Optional[zio.aws.sagemaker.model.ActionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.sagemaker.model.ActionStatus.wrap(value))
    override val properties
        : Optional[Map[StringParameterValue, StringParameterValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.properties())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.sagemaker.model.primitives
                .StringParameterValue(key) -> zio.aws.sagemaker.model.primitives
                .StringParameterValue(value)
            })
            .toMap
        )
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val createdBy
        : Optional[zio.aws.sagemaker.model.UserContext.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdBy())
        .map(value => zio.aws.sagemaker.model.UserContext.wrap(value))
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedBy
        : Optional[zio.aws.sagemaker.model.UserContext.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedBy())
        .map(value => zio.aws.sagemaker.model.UserContext.wrap(value))
    override val metadataProperties
        : Optional[zio.aws.sagemaker.model.MetadataProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metadataProperties())
        .map(value => zio.aws.sagemaker.model.MetadataProperties.wrap(value))
    override val lineageGroupArn: Optional[LineageGroupArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lineageGroupArn())
        .map(value => zio.aws.sagemaker.model.primitives.LineageGroupArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeActionResponse
  ): zio.aws.sagemaker.model.DescribeActionResponse.ReadOnly = new Wrapper(impl)
}
