package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{
  RecommendationJobDescription,
  RoleArn,
  RecommendationJobName
}
import scala.jdk.CollectionConverters._
final case class CreateInferenceRecommendationsJobRequest(
    jobName: RecommendationJobName,
    jobType: zio.aws.sagemaker.model.RecommendationJobType,
    roleArn: RoleArn,
    inputConfig: zio.aws.sagemaker.model.RecommendationJobInputConfig,
    jobDescription: Optional[RecommendationJobDescription] = Optional.Absent,
    stoppingConditions: Optional[
      zio.aws.sagemaker.model.RecommendationJobStoppingConditions
    ] = Optional.Absent,
    outputConfig: Optional[
      zio.aws.sagemaker.model.RecommendationJobOutputConfig
    ] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.sagemaker.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateInferenceRecommendationsJobRequest = {
    import CreateInferenceRecommendationsJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateInferenceRecommendationsJobRequest
      .builder()
      .jobName(RecommendationJobName.unwrap(jobName): java.lang.String)
      .jobType(jobType.unwrap)
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .inputConfig(inputConfig.buildAwsValue())
      .optionallyWith(
        jobDescription.map(value =>
          RecommendationJobDescription.unwrap(value): java.lang.String
        )
      )(_.jobDescription)
      .optionallyWith(stoppingConditions.map(value => value.buildAwsValue()))(
        _.stoppingConditions
      )
      .optionallyWith(outputConfig.map(value => value.buildAwsValue()))(
        _.outputConfig
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.CreateInferenceRecommendationsJobRequest.ReadOnly =
    zio.aws.sagemaker.model.CreateInferenceRecommendationsJobRequest
      .wrap(buildAwsValue())
}
object CreateInferenceRecommendationsJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateInferenceRecommendationsJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.CreateInferenceRecommendationsJobRequest =
      zio.aws.sagemaker.model.CreateInferenceRecommendationsJobRequest(
        jobName,
        jobType,
        roleArn,
        inputConfig.asEditable,
        jobDescription.map(value => value),
        stoppingConditions.map(value => value.asEditable),
        outputConfig.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def jobName: RecommendationJobName
    def jobType: zio.aws.sagemaker.model.RecommendationJobType
    def roleArn: RoleArn
    def inputConfig
        : zio.aws.sagemaker.model.RecommendationJobInputConfig.ReadOnly
    def jobDescription: Optional[RecommendationJobDescription]
    def stoppingConditions: Optional[
      zio.aws.sagemaker.model.RecommendationJobStoppingConditions.ReadOnly
    ]
    def outputConfig: Optional[
      zio.aws.sagemaker.model.RecommendationJobOutputConfig.ReadOnly
    ]
    def tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def getJobName: ZIO[Any, Nothing, RecommendationJobName] =
      ZIO.succeed(jobName)
    def getJobType
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.RecommendationJobType] =
      ZIO.succeed(jobType)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getInputConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.RecommendationJobInputConfig.ReadOnly
    ] = ZIO.succeed(inputConfig)
    def getJobDescription: ZIO[Any, AwsError, RecommendationJobDescription] =
      AwsError.unwrapOptionField("jobDescription", jobDescription)
    def getStoppingConditions: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.RecommendationJobStoppingConditions.ReadOnly
    ] = AwsError.unwrapOptionField("stoppingConditions", stoppingConditions)
    def getOutputConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.RecommendationJobOutputConfig.ReadOnly
    ] = AwsError.unwrapOptionField("outputConfig", outputConfig)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateInferenceRecommendationsJobRequest
  ) extends zio.aws.sagemaker.model.CreateInferenceRecommendationsJobRequest.ReadOnly {
    override val jobName: RecommendationJobName =
      zio.aws.sagemaker.model.primitives.RecommendationJobName(impl.jobName())
    override val jobType: zio.aws.sagemaker.model.RecommendationJobType =
      zio.aws.sagemaker.model.RecommendationJobType.wrap(impl.jobType())
    override val roleArn: RoleArn =
      zio.aws.sagemaker.model.primitives.RoleArn(impl.roleArn())
    override val inputConfig
        : zio.aws.sagemaker.model.RecommendationJobInputConfig.ReadOnly =
      zio.aws.sagemaker.model.RecommendationJobInputConfig
        .wrap(impl.inputConfig())
    override val jobDescription: Optional[RecommendationJobDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobDescription())
        .map(value =>
          zio.aws.sagemaker.model.primitives.RecommendationJobDescription(value)
        )
    override val stoppingConditions: Optional[
      zio.aws.sagemaker.model.RecommendationJobStoppingConditions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.stoppingConditions())
      .map(value =>
        zio.aws.sagemaker.model.RecommendationJobStoppingConditions.wrap(value)
      )
    override val outputConfig: Optional[
      zio.aws.sagemaker.model.RecommendationJobOutputConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.outputConfig())
      .map(value =>
        zio.aws.sagemaker.model.RecommendationJobOutputConfig.wrap(value)
      )
    override val tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateInferenceRecommendationsJobRequest
  ): zio.aws.sagemaker.model.CreateInferenceRecommendationsJobRequest.ReadOnly =
    new Wrapper(impl)
}
